/**
 * CLAWS Constants and Configuration - VERSION 2.0.0
 * Centralized configuration for the CLAWS application
 */

(function() {
    'use strict';
    

    // Constants and Configuration
    window.CLAWS_CONSTANTS = {
        // Color Scheme
        COLORS: {
            // UI Colors
            GRAY_600: '#6b7280',
            GRAY_200: '#e5e7eb',
            GRAY_100: '#f3f4f6',
            GRAY_50: '#f9fafb',
            WHITE: '#ffffff',
            
            // Status Colors  
            SUCCESS: '#10b981',
            ERROR: '#ef4444',
            WARNING: '#f59e0b',
            INFO: '#3b82f6',
            
            // Health Score Colors
            EXCELLENT: '#22c55e',  // green
            GOOD: '#4ade80',       // light green
            FAIR: '#eab308',       // yellow
            POOR: '#f97316',       // orange
            CRITICAL: '#ef4444',   // red
            
            // Chart Colors
            CHART_COLORS: [
                '#E53E3E', '#FF8C00', '#FFD700', '#38A169', 
                '#3182CE', '#4C51BF', '#9F7AEA', '#ec4899'
            ],
            
            // Team/Role Colors
            ADMINISTRATOR: '#dc2626',
            COORDINATOR: '#7c3aed',
            VOLUNTEER: '#059669',
            
            // Activity Colors
            FEEDING: '#10b981',
            SHELTER_BUILDS: '#f59e0b',
            EDUCATION: '#8b5cf6',
            ADMINISTRATION: '#ef4444',
            TRAINING: '#3b82f6',
            MEDICAL: '#ec4899'
        },
        
        // Health Score Thresholds
        HEALTH_THRESHOLDS: {
            EXCELLENT: 80,
            GOOD: 60,
            FAIR: 40
        },
        
        // App Configuration
        VERSION: '2.0.21',
        
        // Chart Configuration
        CHART_DEFAULTS: {
            BORDER_WIDTH: 2,
            POINT_RADIUS: 4,
            FONT_SIZE: 12
        },
        
        // Element IDs
        ELEMENT_IDS: {
            COLONY_CONTENT: 'claws-colony-content',
            COLONY_NAME: 'claws-colony-name',
            COLONY_DATE: 'claws-colony-date',
            TOTAL_COLONIES: 'claws-total-colonies',
            TOTAL_CATS: 'claws-total-cats',
            COLONY_MAP: 'claws-colony-map',
            COLONY_HEALTH_LIST: 'claws-colony-health-list'
        }
    };

})();