// FORCIBLY UPDATE COLONY MODAL - Run after page load
document.addEventListener('DOMContentLoaded', function() {
    console.log('🔧 FORCING COLONY MODAL UPDATE...');
    
    const modal = document.getElementById('claws-add-colony-modal');
    if (!modal) {
        console.error('❌ Modal not found!');
        return;
    }
    
    // Find the cat population section
    const catPopSection = modal.querySelector('h3');
    if (catPopSection && catPopSection.textContent.includes('Cat Population')) {
        // Force 4-column layout
        const parentDiv = catPopSection.nextElementSibling?.nextElementSibling;
        if (parentDiv && parentDiv.style) {
            parentDiv.style.gridTemplateColumns = 'repeat(4, 1fr)';
            console.log('✅ Fixed cat population to 4 columns');
        }
    }
    
    // Find TNR section and add Colony Help after it
    const allDivs = modal.querySelectorAll('div');
    let tnrSection = null;
    
    for (let div of allDivs) {
        const h4 = div.querySelector('h4');
        if (h4 && h4.textContent.includes('How will you help with your TNR')) {
            tnrSection = div;
            break;
        }
    }
    
    if (tnrSection) {
        // Check if Colony Help already exists
        const nextSibling = tnrSection.nextElementSibling;
        if (!nextSibling || !nextSibling.textContent.includes('Colony Help')) {
            console.log('✅ Adding Colony Help section...');
            
            const colonyHelpHTML = `
<div style="margin-top: 1.5rem; padding: 1rem; background: #fff3cd; border: 3px solid #ff0000; border-radius: 0.75rem;">
    <h4 style="font-weight: 700; color: #ff0000; margin: 0 0 0.75rem; font-size: 1.25rem;">🚨 Colony Help: I need assistance with 🚨</h4>
    <p style="font-size: 0.875rem; color: #856404; margin: 0 0 1rem; font-weight: 600;">⚠️ DYNAMICALLY INJECTED BY JAVASCRIPT! ⚠️</p>
    <div style="display: grid; grid-template-columns: 1fr; gap: 0.5rem;">
        <label style="display: flex; align-items: flex-start; gap: 0.5rem; font-size: 0.875rem;">
            <input type="checkbox" class="claws-help-option" data-help-type="traps">
            <span>Traps or other equipment</span>
        </label>
        <label style="display: flex; align-items: flex-start; gap: 0.5rem; font-size: 0.875rem;">
            <input type="checkbox" class="claws-help-option" data-help-type="trapping">
            <span>Trapping</span>
        </label>
        <label style="display: flex; align-items: flex-start; gap: 0.5rem; font-size: 0.875rem;">
            <input type="checkbox" class="claws-help-option" data-help-type="appointments">
            <span>Spay/neuter appointments</span>
        </label>
        <label style="display: flex; align-items: flex-start; gap: 0.5rem; font-size: 0.875rem;">
            <input type="checkbox" class="claws-help-option" data-help-type="food">
            <span>Cat food</span>
        </label>
        <label style="display: flex; align-items: flex-start; gap: 0.5rem; font-size: 0.875rem;">
            <input type="checkbox" class="claws-help-option" data-help-type="caretaking">
            <span>Caretaking assistance</span>
        </label>
        <label style="display: flex; align-items: flex-start; gap: 0.5rem; font-size: 0.875rem;">
            <input type="checkbox" class="claws-help-option" data-help-type="shelters">
            <span>Winter shelters</span>
        </label>
    </div>
</div>`;
            
            tnrSection.insertAdjacentHTML('afterend', colonyHelpHTML);
            console.log('✅ Colony Help section added!');
        } else {
            console.log('ℹ️ Colony Help section already exists');
        }
    }
});
