<?php
/**
 * CLAWS App Container Template
 * Main template for the CLAWS application
 */

if (!defined('ABSPATH')) {
    exit;
}

$is_logged_in = is_user_logged_in();
$show_login_prompt = isset($atts['show_login_prompt']) ? $atts['show_login_prompt'] === 'true' : true;
?>

<script>
console.log('🔥🔥🔥 PURRALYTICS TEMPLATE VERSION: 2.0.51 🔥🔥🔥');
console.log('Template loaded at:', new Date().toISOString());
console.log('If you see this message, the PHP template IS loading!');
console.log('Cache timestamp:', <?php echo time(); ?>);

// Force update the modal if it exists
document.addEventListener('DOMContentLoaded', function() {
    const modal = document.getElementById('claws-add-colony-modal');
    if (modal) {
        console.log('✅ Colony modal found in DOM');
        console.log('Modal HTML length:', modal.innerHTML.length);
        
        // Check if our version indicators are present
        const hasVersionBadge = modal.innerHTML.includes('v2.0.50') || modal.innerHTML.includes('v2.0.51');
        const hasRedBorder = modal.innerHTML.includes('#ff0000') || modal.innerHTML.includes('Colony Help');
        
        console.log('Has version badge:', hasVersionBadge);
        console.log('Has Colony Help section:', hasRedBorder);
        
        if (!hasVersionBadge || !hasRedBorder) {
            console.error('❌ MODAL IS CACHED! The changes are NOT in the DOM!');
            console.error('You must clear WordPress cache + browser cache');
        } else {
            console.log('✅ Modal has latest changes!');
        }
    } else {
        console.error('❌ Colony modal NOT found in DOM');
    }
});
</script>

<!-- Login Required Banner -->
<?php if (!$is_logged_in): ?>
<div id="claws-login-banner" class="claws-login-required">
    🔒 LOGIN REQUIRED - Access restricted to registered users
</div>
<?php endif; ?>

<!-- Trial Countdown Banner -->
<?php if ($is_logged_in && function_exists('pur_fs') && pur_fs()->is_trial()): ?>
    <?php 
    $trial = pur_fs()->get_trial_plan();
    if ($trial) {
        $days_left = ceil(($trial->trial_ends - time()) / DAY_IN_SECONDS);
        if ($days_left < 0) $days_left = 0;
    ?>
    <div style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 0.75rem; text-align: center; font-size: 0.875rem; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
        ⏰ <strong>Trial: <?php echo $days_left; ?> day<?php echo $days_left !== 1 ? 's' : ''; ?> remaining</strong> 
        - Enjoying Purralytics? 
        <a href="<?php echo esc_url(pur_fs()->get_upgrade_url()); ?>" style="color: #fde047; text-decoration: underline; font-weight: 600; margin-left: 0.5rem;">
            Upgrade Now →
        </a>
    </div>
    <?php } ?>
<?php endif; ?>

<!-- Main App Container -->
<div class="claws-app-wrapper claws-responsive-container" style="margin: 0 auto; background: #f9fafb; min-height: <?php echo esc_attr($atts['height']); ?>; display: flex; flex-direction: column;">
    
    <!-- Header (Master Header) -->
    <div class="claws-master-header claws-header-gradient">
        <div style="padding: 1.5rem 1.5rem 1rem; display: flex; align-items: center; justify-content: space-between;">
            <div style="display: flex; align-items: center; gap: 0.5rem;">
                <span>☰</span>
            </div>
            <div style="display: flex; align-items: center; gap: 0.75rem;">
                <div class="claws-logo-container" style="width: 2.5rem; height: 2.5rem; background: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; overflow: hidden;">
                    <?php 
                    $logo_id = get_option('claws_organization_logo', 0);
                    $logo_url = '';
                    
                    // Validate logo exists and is accessible
                    if ($logo_id) {
                        $logo_url = wp_get_attachment_url($logo_id);
                        // Double-check the attachment still exists
                        if (!$logo_url || !get_post($logo_id)) {
                            $logo_url = '';
                        }
                    }
                    
                    if ($logo_url): ?>
                        <img src="<?php echo esc_url($logo_url); ?>" 
                             style="width: 100%; height: 100%; object-fit: cover;" 
                             alt="<?php echo esc_attr(get_option('claws_organization_name', 'CLAWS')); ?> Logo"
                             onerror="this.style.display='none'; this.nextElementSibling.style.display='inline';" />
                        <span style="color: <?php echo esc_attr(get_option('claws_primary_color', '#C1292E')); ?>; font-size: 1.5rem; display: none;">❤</span>
                    <?php else: ?>
                        <span style="color: <?php echo esc_attr(get_option('claws_primary_color', '#C1292E')); ?>; font-size: 1.5rem;">❤</span>
                    <?php endif; ?>
                </div>
                <h1 style="font-size: 1.5rem; font-weight: bold; margin: 0; color: white;"><?php echo esc_html(get_option('claws_organization_name', 'CLAWS')); ?></h1>
            </div>
            <div id="claws-user-status" style="display: flex; align-items: center; gap: 0.5rem; font-size: 0.75rem;">
                <?php if ($is_logged_in): ?>
                    <span style="color: #86efac;">Logged In</span>
                <?php else: ?>
                    <span style="color: #fca5a5;">Demo Mode</span>
                <?php endif; ?>
            </div>
        </div>
        <div style="text-align: center; padding-bottom: 1.5rem;">
            <p style="color: #bfdbfe; font-size: 0.875rem; margin: 0;"><?php echo esc_html(get_option('claws_organization_tagline', 'Compassionate care for every cat')); ?></p>
        </div>
    </div>

    <!-- Navigation Tabs -->
    <div style="background: white; border-bottom: 1px solid #e5e7eb; padding: 0.5rem 1rem;">
        <div style="display: flex; justify-content: space-around;">
            <button onclick="CLAWSApp.switchTab('colony')" id="claws-tab-colony" class="claws-tab-active claws-child-header" style="display: flex; flex-direction: column; align-items: center; gap: 0.25rem; padding: 0.75rem; border-radius: 0.5rem; border: none; cursor: pointer; transition: all 0.2s;">
                <span style="font-size: 1.25rem;">📍</span>
                <span style="font-size: 0.75rem; font-weight: 500;">Colony Tracker</span>
            </button>
            <button onclick="CLAWSApp.switchTab('intake')" id="claws-tab-intake" style="display: flex; flex-direction: column; align-items: center; gap: 0.25rem; padding: 0.75rem; border-radius: 0.5rem; border: none; cursor: pointer; transition: all 0.2s; color: #6b7280; background: transparent;">
                <span style="font-size: 1.25rem;">❤️</span>
                <span style="font-size: 0.75rem; font-weight: 500;">Intake</span>
            </button>
            <button onclick="CLAWSApp.switchTab('discharge')" id="claws-tab-discharge" style="display: flex; flex-direction: column; align-items: center; gap: 0.25rem; padding: 0.75rem; border-radius: 0.5rem; border: none; cursor: pointer; transition: all 0.2s; color: #6b7280; background: transparent;">
                <span style="font-size: 1.25rem;">➡️</span>
                <span style="font-size: 0.75rem; font-weight: 500;">Discharge</span>
            </button>
            <?php if (get_option('claws_enable_neonate_feeding', 0)): ?>
            <button onclick="CLAWSApp.switchTab('neonate')" id="claws-tab-neonate" style="display: flex; flex-direction: column; align-items: center; gap: 0.25rem; padding: 0.75rem; border-radius: 0.5rem; border: none; cursor: pointer; transition: all 0.2s; color: #6b7280; background: transparent;">
                <span style="font-size: 1.25rem;">📅</span>
                <span style="font-size: 0.75rem; font-weight: 500;">NeoNate Care</span>
            </button>
            <?php endif; ?>
            <?php if (current_user_can('publish_posts')): ?>
                <?php if (pur_can_use_volunteer_features()): ?>
                    <!-- Show actual Volunteer tab -->
                    <button onclick="CLAWSApp.switchTab('volunteers')" id="claws-tab-volunteers" style="display: flex; flex-direction: column; align-items: center; gap: 0.25rem; padding: 0.75rem; border-radius: 0.5rem; border: none; cursor: pointer; transition: all 0.2s; color: #6b7280; background: transparent;">
                        <span style="font-size: 1.25rem;">👥</span>
                        <span style="font-size: 0.75rem; font-weight: 500;">Volunteers</span>
                    </button>
                <?php else: ?>
                    <!-- Show upgrade teaser for Basic plan users -->
                    <button onclick="location.href='<?php echo esc_url(pur_fs()->get_upgrade_url()); ?>'" 
                            id="claws-tab-volunteers-locked"
                            style="display: flex; flex-direction: column; align-items: center; gap: 0.25rem; padding: 0.75rem; border-radius: 0.5rem; border: 2px dashed #d1d5db; cursor: pointer; transition: all 0.2s; color: #9ca3af; background: transparent; position: relative;"
                            onmouseover="this.style.borderColor='#667eea'; this.style.color='#667eea';" 
                            onmouseout="this.style.borderColor='#d1d5db'; this.style.color='#9ca3af';"
                            title="Upgrade to Deluxe plan to unlock Volunteer Management">
                        <span style="font-size: 1.25rem; opacity: 0.5;">🔒</span>
                        <span style="font-size: 0.75rem; font-weight: 500;">Volunteers</span>
                        <span style="position: absolute; top: -8px; right: -8px; background: #ef4444; color: white; font-size: 0.625rem; padding: 2px 6px; border-radius: 10px; font-weight: bold;">DELUXE</span>
                    </button>
                <?php endif; ?>
            <?php endif; ?>
        </div>
    </div>

    <!-- Content Container -->
    <div style="flex: 1; display: flex; flex-direction: column;" id="claws-content-container">
        
        <!-- Login Prompt -->
        <?php if (!$is_logged_in && $show_login_prompt): ?>
        <div class="claws-login-prompt claws-child-header" style="padding: 1rem; border-radius: 1rem; text-align: center; margin: 1rem;">
            <h3 style="font-size: 1.125rem; font-weight: bold; margin: 0 0 0.5rem;">🔑 Login Required</h3>
            <p style="margin: 0 0 1rem;">Please log in to view and manage colony data. Access is restricted to registered users only.</p>
            <a href="<?php echo esc_url(wp_login_url(get_permalink())); ?>" style="background: white; color: #2563eb; padding: 0.5rem 1rem; border-radius: 0.5rem; text-decoration: none; font-weight: 500;">
                Login to WordPress
            </a>
        </div>
        <?php endif; ?>
        
        <!-- Content Sections -->
        <div style="flex: 1; overflow-y: auto;" id="claws-scrollable-content">
            
            <!-- Colony Tracker Section -->
            <div id="claws-colony-section" class="claws-content-section">
                <!-- Map will be loaded here -->
                <div id="claws-map-container" style="background: white; border-radius: 1rem; margin: 1rem; box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1); border: 1px solid #e5e7eb; overflow: hidden;">
                    <div id="claws-colony-map" style="height: 520px !important; border-radius: 1rem; overflow: hidden;">
                        <div style="height: 100%; background: #f3f4f6; display: flex; align-items: center; justify-content: center; color: #6b7280;">
                            <div style="text-align: center;">
                                <p style="margin: 0 0 0.5rem;">🗺️ Loading Map...</p>
                            </div>
                        </div>
                    </div>
                    <div style="padding: 0.5rem; background: #f9fafb; border-top: 1px solid #e5e7eb;">
                        <p style="font-size: 0.875rem; color: #6b7280; text-align: center; margin: 0;">
                            📍 <?php echo esc_html(get_option('claws_default_location', 'Lebanon, VA')); ?> Colony Locations - Click markers for details
                        </p>
                    </div>
                </div>
                
                <!-- Colony Actions - Always Visible -->
                <div id="claws-colony-actions" style="padding: 1rem;">
                    <div class="claws-child-header" style="border-radius: 1rem; padding: 1.5rem;">
                        <div style="display: flex; align-items: center; justify-content: space-between; margin-bottom: 1rem;">
                            <h3 style="font-weight: 600; font-size: 1.125rem; margin: 0; color: inherit;">Colony Actions</h3>
                            <span style="font-size: 1.5rem;">➕</span>
                        </div>
                        <div style="display: flex; flex-direction: column; gap: 0.75rem;">
                            <button onclick="CLAWSApp.showAddColonyForm(); console.log('Add Colony button clicked from permanent section!');" style="width: 100%; background: rgba(255, 255, 255, 0.2); border: none; border-radius: 0.75rem; padding: 0.75rem; cursor: pointer; transition: background 0.2s; text-align: left; color: inherit;" onmouseover="this.style.background='rgba(255,255,255,0.3)'" onmouseout="this.style.background='rgba(255,255,255,0.2)'">
                                <span style="font-weight: 500;">🏠 Add New Colony</span>
                            </button>
                            <button onclick="CLAWSApp.exportColonyData();" style="width: 100%; background: rgba(16, 185, 129, 0.2); border: none; border-radius: 0.75rem; padding: 0.75rem; cursor: pointer; transition: background 0.2s; text-align: left; color: inherit;" onmouseover="this.style.background='rgba(16, 185, 129, 0.3)'" onmouseout="this.style.background='rgba(16, 185, 129, 0.2)'">
                                <span style="font-weight: 500;">📊 Export Data</span>
                            </button>
                        </div>
                    </div>
                </div>
                
                <!-- Statistics and content will be loaded by JavaScript -->
                <div id="claws-colony-content">
                    <div style="text-align: center; padding: 2rem;">
                        <p style="color: #6b7280;">Loading colony data...</p>
                    </div>
                </div>
            </div>
            
            <!-- Intake Section -->
            <div id="claws-intake-section" class="claws-content-section claws-section-hidden">
                <div id="claws-intake-content">
                    <div style="text-align: center; padding: 2rem;">
                        <p style="color: #6b7280;">Loading intake forms...</p>
                    </div>
                </div>
            </div>
            
            <!-- Discharge Section -->
            <div id="claws-discharge-section" class="claws-content-section claws-section-hidden">
                <div id="claws-discharge-content">
                    <div style="text-align: center; padding: 2rem;">
                        <p style="color: #6b7280;">Loading discharge forms...</p>
                    </div>
                </div>
            </div>
            
            <!-- Neonate Care Section -->
            <?php if (get_option('claws_enable_neonate_feeding', 0)): ?>
            <div id="claws-neonate-section" class="claws-content-section claws-section-hidden">
                <div id="claws-neonate-content">
                    <div style="text-align: center; padding: 2rem;">
                        <p style="color: #6b7280;">Loading neonate care...</p>
                    </div>
                </div>
            </div>
            <?php endif; ?>
            
            <!-- Volunteers Section or Upgrade Prompt -->
            <?php if (current_user_can('publish_posts')): ?>
                <?php if (pur_can_use_volunteer_features()): ?>
                    <!-- Actual Volunteers Section (Deluxe or Trial users) -->
                    <div id="claws-volunteers-section" class="claws-content-section claws-section-hidden">
                        <div id="claws-volunteers-content">
                            <!-- Volunteers Sub-Tab Navigation -->
                    <div style="background: white; border-bottom: 1px solid #e5e7eb; padding: 0.5rem 1rem; margin: -1rem -1rem 1rem -1rem;">
                        <div style="display: flex; gap: 0.5rem; flex-wrap: wrap;">
                            <button onclick="CLAWSApp.switchVolunteerSubTab('mytime')" id="claws-volunteers-subtab-mytime" class="claws-volunteers-subtab-active claws-child-header" style="padding: 0.5rem 1rem; border-radius: 0.375rem; border: none; cursor: pointer; transition: all 0.2s; font-size: 0.875rem; font-weight: 500;">
                                ⏰ My Time
                            </button>
                            <button onclick="CLAWSApp.switchVolunteerSubTab('events')" id="claws-volunteers-subtab-events" style="padding: 0.5rem 1rem; border-radius: 0.375rem; border: none; cursor: pointer; transition: all 0.2s; background: transparent; color: #6b7280; font-size: 0.875rem; font-weight: 500;">
                                🌟 Events/Projects
                            </button>
                            <button onclick="CLAWSApp.switchVolunteerSubTab('teams')" id="claws-volunteers-subtab-teams" style="padding: 0.5rem 1rem; border-radius: 0.375rem; border: none; cursor: pointer; transition: all 0.2s; background: transparent; color: #6b7280; font-size: 0.875rem; font-weight: 500;">
                                👥 Teams
                            </button>
                            <button onclick="CLAWSApp.switchVolunteerSubTab('statsgoals')" id="claws-volunteers-subtab-statsgoals" style="padding: 0.5rem 1rem; border-radius: 0.375rem; border: none; cursor: pointer; transition: all 0.2s; background: transparent; color: #6b7280; font-size: 0.875rem; font-weight: 500;">
                                📈 Stats & Goals
                            </button>
                            <button onclick="CLAWSApp.switchVolunteerSubTab('comms')" id="claws-volunteers-subtab-comms" style="padding: 0.5rem 1rem; border-radius: 0.375rem; border: none; cursor: pointer; transition: all 0.2s; background: transparent; color: #6b7280; font-size: 0.875rem; font-weight: 500;">
                                💬 Comms
                            </button>
                            <button onclick="CLAWSApp.switchVolunteerSubTab('admin')" id="claws-volunteers-subtab-admin" style="padding: 0.5rem 1rem; border-radius: 0.375rem; border: none; cursor: pointer; transition: all 0.2s; background: transparent; color: #6b7280; font-size: 0.875rem; font-weight: 500;">
                                🔧 Admin
                            </button>
                        </div>
                    </div>
                    
                    <!-- Volunteers Sub-Tab Content -->
                    <div id="claws-volunteers-subtab-content">
                        <!-- My Time Sub-Tab -->
                        <div id="claws-volunteers-mytime" class="claws-volunteers-subtab-section">
                            <div style="padding: 1.5rem; max-width: 800px; margin: 0 auto;">
                                
                                <!-- Enter Completed Task Section -->
                                <div class="claws-child-header" style="border-radius: 0.75rem; padding: 1.5rem; margin-bottom: 2rem;">
                                    <h4 style="color: inherit; margin-bottom: 1rem; font-size: 1.25rem; font-weight: 600; display: flex; align-items: center;">
                                        <span style="margin-right: 0.5rem;">✅</span> Enter Completed Task
                                    </h4>
                                    <button onclick="CLAWSApp.showCompletedTaskForm()" style="width: 100%; background: rgba(255, 255, 255, 0.2); border: none; border-radius: 0.75rem; padding: 0.75rem; cursor: pointer; font-weight: 500; transition: background 0.2s; color: inherit;" onmouseover="this.style.background='rgba(255,255,255,0.3)'" onmouseout="this.style.background='rgba(255,255,255,0.2)'">
                                        📝 Enter Task
                                    </button>
                                </div>

                                <!-- Needs Attention -->
                                <div id="claws-needs-attention-section" style="background: #fef3c7; border: 1px solid #f59e0b; border-radius: 0.75rem; padding: 1.5rem; margin-bottom: 2rem; display: none;">
                                    <h4 style="color: #92400e; margin-bottom: 1rem; font-size: 1.125rem; font-weight: 600; display: flex; align-items: center;">
                                        <span style="margin-right: 0.5rem;">⚠️</span> Needs Attention
                                    </h4>
                                    <p style="color: #92400e; font-size: 0.875rem; margin-bottom: 1rem;">
                                        These tasks require revision or additional information before they can be approved.
                                    </p>
                                    <div id="claws-needs-attention-items" style="text-align: center; padding: 2rem; color: #92400e;">
                                        No items need attention.
                                    </div>
                                </div>

                                <!-- Pending Approval -->
                                <div style="background: white; border-radius: 0.75rem; border: 1px solid #e5e7eb; padding: 1.5rem; margin-bottom: 2rem;">
                                    <h4 style="color: #1f2937; margin-bottom: 1rem; font-size: 1.125rem; font-weight: 600; display: flex; align-items: center;">
                                        <span style="margin-right: 0.5rem;">⏳</span> Pending Approval
                                    </h4>
                                    <div id="claws-my-time-pending" style="text-align: center; padding: 2rem; color: #6b7280;">
                                        No items pending approval.
                                    </div>
                                </div>

                                <!-- Approved Tasks & Events -->
                                <div style="background: white; border-radius: 0.75rem; border: 1px solid #e5e7eb; padding: 1.5rem;">
                                    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1rem; flex-wrap: wrap; gap: 1rem;">
                                        <h4 style="color: #1f2937; margin: 0; font-size: 1.125rem; font-weight: 600; display: flex; align-items: center;">
                                            <span style="margin-right: 0.5rem;">✅</span> Approved Items
                                        </h4>
                                        <div style="display: flex; align-items: center; gap: 0.5rem;">
                                            <label style="color: #374151; font-size: 0.875rem; font-weight: 500;">Show completed items for:</label>
                                            <select id="claws-time-period-filter" onchange="CLAWSApp.filterApprovedItems()" style="padding: 0.5rem; border: 1px solid #d1d5db; border-radius: 0.375rem; font-size: 0.875rem; background: white;">
                                                <option value="3months">3 months</option>
                                                <option value="6months">6 months</option>
                                                <option value="1year">1 year</option>
                                                <option value="alltime">All time</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div id="claws-my-time-approved" style="text-align: center; padding: 2rem; color: #6b7280;">
                                        No approved items for the selected time period.
                                    </div>
                                </div>
                                
                            </div>
                        </div>
                        
                        <!-- Events/Projects Sub-Tab -->
                        <div id="claws-volunteers-events" class="claws-volunteers-subtab-section" style="display: none;">
                            <div style="padding: 1.5rem; max-width: 1200px; margin: 0 auto;">
                                <!-- Available Events Section -->
                                <div style="margin-bottom: 2rem;">
                                    <h3 style="color: #1f2937; margin-bottom: 1rem; font-size: 1.5rem; font-weight: 600; display: flex; align-items: center;">
                                        <span style="margin-right: 0.5rem;">📅</span> Available Events
                                    </h3>
                                    <p style="color: #6b7280; font-size: 0.875rem; margin-bottom: 1rem;">
                                        One-time opportunities with specific dates and times
                                    </p>
                                    
                                    <!-- Events List -->
                                    <div id="claws-events-list" style="background: white; border-radius: 0.75rem; border: 1px solid #e5e7eb; overflow: hidden;">
                                        <div style="text-align: center; padding: 3rem; color: #6b7280;">
                                            <div style="font-size: 3rem; margin-bottom: 1rem;">🔍</div>
                                            <p style="font-size: 1.125rem; margin: 0;">Loading available events...</p>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Available Projects Section -->
                                <div style="margin-bottom: 2rem;">
                                    <h3 style="color: #1f2937; margin-bottom: 1rem; font-size: 1.5rem; font-weight: 600; display: flex; align-items: center;">
                                        <span style="margin-right: 0.5rem;">🔄</span> Available Projects
                                    </h3>
                                    <p style="color: #6b7280; font-size: 0.875rem; margin-bottom: 1rem;">
                                        Ongoing opportunities without specific end dates
                                    </p>
                                    
                                    <!-- Projects List -->
                                    <div id="claws-projects-list" style="background: white; border-radius: 0.75rem; border: 1px solid #e5e7eb; overflow: hidden;">
                                        <div style="text-align: center; padding: 3rem; color: #6b7280;">
                                            <div style="font-size: 3rem; margin-bottom: 1rem;">🔍</div>
                                            <p style="font-size: 1.125rem; margin: 0;">Loading available projects...</p>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Divider -->
                                <div style="border-top: 2px solid #e5e7eb; margin: 2rem 0; position: relative;">
                                    <div style="position: absolute; top: -12px; left: 50%; transform: translateX(-50%); background: #f9fafb; padding: 0 1rem; color: #6b7280; font-size: 0.875rem; font-weight: 500;">
                                        Create New
                                    </div>
                                </div>
                                
                                <!-- Create Event/Project Buttons Section -->
                                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1.5rem;">
                                    <!-- Add New Event Section -->
                                    <div class="claws-child-header" style="border-radius: 0.75rem; padding: 1.5rem;">
                                        <h4 style="color: inherit; margin-bottom: 1rem; font-size: 1.25rem; font-weight: 600; display: flex; align-items: center;">
                                            <span style="margin-right: 0.5rem;">📅</span> Add New Event
                                        </h4>
                                        <p style="color: inherit; opacity: 0.9; font-size: 0.875rem; margin-bottom: 1rem;">
                                            One-time opportunity with date & time
                                        </p>
                                        
                                        <?php
                                        // Check event creation permissions
                                        $event_creation_level = get_option('claws_event_creation_level', 'editors'); // 'authors' or 'editors'
                                        $current_user = wp_get_current_user();
                                        $can_create_opportunities = false;
                                        
                                        if (current_user_can('manage_options')) {
                                            // Admins can always create opportunities
                                            $can_create_opportunities = true;
                                        } elseif ($event_creation_level === 'authors' && current_user_can('publish_posts')) {
                                            // Authors and above can create (when set to authors level)
                                            $can_create_opportunities = true;
                                        } elseif ($event_creation_level === 'editors' && current_user_can('edit_others_posts')) {
                                            // Editors and above can create (when set to editors level)
                                            $can_create_opportunities = true;
                                        }
                                        ?>
                                        
                                        <div style="text-align: center;">
                                            <?php if ($can_create_opportunities): ?>
                                            <button onclick="CLAWSApp.showAddEventForm()" id="claws-add-event-btn" 
                                                    class="claws-child-button" style="width: 100%; border: none; padding: 0.75rem 1.5rem; border-radius: 0.5rem; font-size: 1rem; font-weight: 500; cursor: pointer; transition: all 0.2s; display: inline-flex; align-items: center; justify-content: center; gap: 0.5rem;">
                                                <span style="font-size: 1.25rem;">✨</span>
                                                Create New Event
                                            </button>
                                            <?php else: ?>
                                            <button disabled 
                                                    style="width: 100%; background: #9ca3af; color: #6b7280; border: none; padding: 0.75rem 1.5rem; border-radius: 0.5rem; font-size: 1rem; font-weight: 500; cursor: not-allowed; display: inline-flex; align-items: center; justify-content: center; gap: 0.5rem;">
                                                <span style="font-size: 1.25rem;">🔒</span>
                                                Create New Event
                                            </button>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    
                                    <!-- Add New Project Section -->
                                    <div class="claws-child-header" style="border-radius: 0.75rem; padding: 1.5rem;">
                                        <h4 style="color: inherit; margin-bottom: 1rem; font-size: 1.25rem; font-weight: 600; display: flex; align-items: center;">
                                            <span style="margin-right: 0.5rem;">🔄</span> Add New Project
                                        </h4>
                                        <p style="color: inherit; opacity: 0.9; font-size: 0.875rem; margin-bottom: 1rem;">
                                            Ongoing opportunity without end date
                                        </p>
                                        
                                        <div style="text-align: center;">
                                            <?php if ($can_create_opportunities): ?>
                                            <button onclick="CLAWSApp.showAddProjectForm()" id="claws-add-project-btn" 
                                                    class="claws-child-button" style="width: 100%; border: none; padding: 0.75rem 1.5rem; border-radius: 0.5rem; font-size: 1rem; font-weight: 500; cursor: pointer; transition: all 0.2s; display: inline-flex; align-items: center; justify-content: center; gap: 0.5rem;">
                                                <span style="font-size: 1.25rem;">✨</span>
                                                Create New Project
                                            </button>
                                            <?php else: ?>
                                            <button disabled 
                                                    style="width: 100%; background: #9ca3af; color: #6b7280; border: none; padding: 0.75rem 1.5rem; border-radius: 0.5rem; font-size: 1rem; font-weight: 500; cursor: not-allowed; display: inline-flex; align-items: center; justify-content: center; gap: 0.5rem;">
                                                <span style="font-size: 1.25rem;">🔒</span>
                                                Create New Project
                                            </button>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                                
                                <?php if (!$can_create_opportunities): ?>
                                <p style="color: #6b7280; font-size: 0.875rem; margin: 1rem 0; text-align: center; font-style: italic;">
                                    Only Coordinators and Admins can create new opportunities.
                                </p>
                                <?php endif; ?>
                                
                                <!-- Divider -->
                                <div style="border-top: 2px solid #e5e7eb; margin: 3rem 0 2rem; position: relative;">
                                    <div style="position: absolute; top: -12px; left: 50%; transform: translateX(-50%); background: #f9fafb; padding: 0 1rem; color: #6b7280; font-size: 0.875rem; font-weight: 500;">
                                        History & Archives
                                    </div>
                                </div>
                                
                                <!-- Past Events & Retired Projects Section -->
                                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1.5rem; margin-top: 2rem;">
                                    <!-- Past Events -->
                                    <div style="background: #f9fafb; border-radius: 0.75rem; border: 1px dashed #d1d5db; padding: 1.5rem;">
                                        <h4 style="color: #6b7280; margin-bottom: 1rem; font-size: 1.125rem; font-weight: 600; display: flex; align-items: center;">
                                            <span style="margin-right: 0.5rem;">🗓️</span> Past Events
                                        </h4>
                                        <p style="color: #9ca3af; font-size: 0.875rem; margin-bottom: 1rem;">
                                            Completed events for reporting
                                        </p>
                                        <div id="claws-past-events-list" style="background: white; border-radius: 0.5rem; border: 1px solid #e5e7eb; padding: 1rem; min-height: 100px;">
                                            <p style="color: #9ca3af; font-size: 0.875rem; text-align: center; margin: 2rem 0;">
                                                Coming soon...
                                            </p>
                                        </div>
                                    </div>
                                    
                                    <!-- Retired Projects -->
                                    <div style="background: #f9fafb; border-radius: 0.75rem; border: 1px dashed #d1d5db; padding: 1.5rem;">
                                        <h4 style="color: #6b7280; margin-bottom: 1rem; font-size: 1.125rem; font-weight: 600; display: flex; align-items: center;">
                                            <span style="margin-right: 0.5rem;">📦</span> Retired Projects
                                        </h4>
                                        <p style="color: #9ca3af; font-size: 0.875rem; margin-bottom: 1rem;">
                                            Archived projects for reporting
                                        </p>
                                        <div id="claws-retired-projects-list" style="background: white; border-radius: 0.5rem; border: 1px solid #e5e7eb; padding: 1rem; min-height: 100px;">
                                            <p style="color: #9ca3af; font-size: 0.875rem; text-align: center; margin: 2rem 0;">
                                                Coming soon...
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Teams Sub-Tab -->
                        <div id="claws-volunteers-teams" class="claws-volunteers-subtab-section" style="display: none;">
                            <div style="padding: 1.5rem; max-width: 1200px; margin: 0 auto;">
                                
                                <div style="text-align: center; margin-bottom: 2rem;">
                                    <h3 style="color: #1f2937; font-size: 1.75rem; font-weight: 600; margin-bottom: 0.5rem;">👥 
                                        <?php echo current_user_can('manage_options') ? 'All Teams' : 'My Teams'; ?>
                                    </h3>
                                    <p style="color: #6b7280; font-size: 0.875rem;">
                                        <?php if (current_user_can('manage_options')): ?>
                                            Organization-wide overview of all active teams from events and projects.
                                        <?php else: ?>
                                            Teams you're part of. Join an event or project to become part of a team!
                                        <?php endif; ?>
                                    </p>
                                </div>
                                
                                <!-- Event Teams Section -->
                                <div style="margin-bottom: 2rem;">
                                    <h4 style="color: #1f2937; margin-bottom: 1rem; font-size: 1.25rem; font-weight: 600; display: flex; align-items: center;">
                                        <span style="margin-right: 0.5rem;">📅</span> Event Teams
                                    </h4>
                                    <p style="color: #6b7280; font-size: 0.875rem; margin-bottom: 1rem;">
                                        Teams formed for specific events. These teams close when the event is completed.
                                    </p>
                                    
                                    <div id="claws-event-teams-list">
                                        <div style="text-align: center; padding: 3rem; background: white; border-radius: 0.75rem; border: 1px solid #e5e7eb;">
                                            <div style="font-size: 3rem; margin-bottom: 1rem;">🔍</div>
                                            <p style="font-size: 1.125rem; color: #6b7280; margin: 0;">Loading event teams...</p>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Project Teams Section -->
                                <div style="margin-bottom: 2rem;">
                                    <h4 style="color: #1f2937; margin-bottom: 1rem; font-size: 1.25rem; font-weight: 600; display: flex; align-items: center;">
                                        <span style="margin-right: 0.5rem;">🔄</span> Project Teams
                                    </h4>
                                    <p style="color: #6b7280; font-size: 0.875rem; margin-bottom: 1rem;">
                                        Teams formed for ongoing projects. These teams remain active until the project is closed.
                                    </p>
                                    
                                    <div id="claws-project-teams-list">
                                        <div style="text-align: center; padding: 3rem; background: white; border-radius: 0.75rem; border: 1px solid #e5e7eb;">
                                            <div style="font-size: 3rem; margin-bottom: 1rem;">🔍</div>
                                            <p style="font-size: 1.125rem; color: #6b7280; margin: 0;">Loading project teams...</p>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Info Box -->
                                <div style="background: #f0f9ff; border: 1px solid #0ea5e9; border-radius: 0.75rem; padding: 1.5rem; margin-top: 2rem;">
                                    <h5 style="color: #0369a1; margin: 0 0 0.75rem; font-weight: 600; font-size: 1rem;">💡 How Teams Work</h5>
                                    <ul style="color: #0369a1; margin: 0; padding-left: 1.5rem; font-size: 0.875rem; line-height: 1.6;">
                                        <li><strong>Automatic Creation:</strong> Teams are automatically created when events or projects are made.</li>
                                        <li><strong>Team Leader:</strong> The event/project coordinator is the team leader (shown with 👑 crown).</li>
                                        <li><strong>Team Members:</strong> Volunteers who sign up for the event/project become team members.</li>
                                        <li><strong>Open Spots:</strong> Empty volunteer spots show as "Volunteer Needed" until someone signs up.</li>
                                        <li><strong>Event Teams:</strong> Disband when the event is completed.</li>
                                        <li><strong>Project Teams:</strong> Remain active until the coordinator closes the project.</li>
                                        <?php if (current_user_can('manage_options')): ?>
                                        <li><strong>Admin View:</strong> You can see all teams across the organization to monitor who's doing what.</li>
                                        <?php else: ?>
                                        <li><strong>To join a team:</strong> Go to the Events/Projects tab and sign up!</li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Stats & Goals Sub-Tab -->
                        <div id="claws-volunteers-statsgoals" class="claws-volunteers-subtab-section" style="display: none;">
                            <div style="padding: 1.5rem; max-width: 1400px; margin: 0 auto;">
                                
                                <!-- Personal Stats Section -->
                                <div style="margin-bottom: 3rem;">
                                    <div style="text-align: center; margin-bottom: 2rem;">
                                        <h3 style="color: #1f2937; font-size: 1.75rem; font-weight: 600; margin-bottom: 0.5rem;">
                                            📊 My Volunteer Stats
                                        </h3>
                                        <p style="color: #6b7280; font-size: 0.875rem;">Your personal volunteer impact and achievements</p>
                                    </div>
                                    
                                    <!-- Stats Grid -->
                                    <div id="claws-personal-stats-grid" style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 1.5rem; margin-bottom: 2rem;">
                                        <!-- Loading state -->
                                        <div style="grid-column: 1/-1; text-align: center; padding: 3rem;">
                                            <div style="font-size: 3rem; margin-bottom: 1rem;">📊</div>
                                            <p style="color: #6b7280;">Loading your stats...</p>
                                        </div>
                                    </div>
                                    
                                    <!-- Detailed Breakdown -->
                                    <div id="claws-personal-details" style="display: none;">
                                        <h4 style="color: #1f2937; margin-bottom: 1rem; font-size: 1.25rem; font-weight: 600;">
                                            📋 Recent Activity
                                        </h4>
                                        <div id="claws-recent-activity" style="background: white; border-radius: 0.75rem; border: 1px solid #e5e7eb; padding: 1.5rem;">
                                            <!-- Will be populated by JS -->
                                        </div>
                                    </div>
                                </div>
                                
                                <?php if (current_user_can('manage_options')): ?>
                                <!-- Organization Stats Section (Admin Only) -->
                                <div style="margin-bottom: 2rem; padding-top: 2rem; border-top: 2px solid #e5e7eb;">
                                    <div style="text-align: center; margin-bottom: 2rem;">
                                        <h3 style="color: #1f2937; font-size: 1.75rem; font-weight: 600; margin-bottom: 0.5rem;">
                                            🏢 Organization Stats
                                        </h3>
                                        <p style="color: #6b7280; font-size: 0.875rem;">Overall volunteer program impact across the organization</p>
                                    </div>
                                    
                                    <!-- Org Stats Grid -->
                                    <div id="claws-org-stats-grid" style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 1.5rem; margin-bottom: 2rem;">
                                        <!-- Loading state -->
                                        <div style="grid-column: 1/-1; text-align: center; padding: 3rem;">
                                            <div style="font-size: 3rem; margin-bottom: 1rem;">🏢</div>
                                            <p style="color: #6b7280;">Loading organization stats...</p>
                                        </div>
                                    </div>
                                    
                                    <!-- Top Volunteers -->
                                    <div style="margin-top: 2rem;">
                                        <h4 style="color: #1f2937; margin-bottom: 1rem; font-size: 1.25rem; font-weight: 600;">
                                            🏆 Top Volunteers
                                        </h4>
                                        <div id="claws-top-volunteers" style="background: white; border-radius: 0.75rem; border: 1px solid #e5e7eb; padding: 1.5rem;">
                                            <!-- Will be populated by JS -->
                                        </div>
                                    </div>
                                </div>
                                <?php endif; ?>
                                
                            </div>
                        </div>
                        
                        <!-- Comms Sub-Tab -->
                        <div id="claws-volunteers-comms" class="claws-volunteers-subtab-section" style="display: none;">
                            <div style="padding: 1.5rem; max-width: 1400px; margin: 0 auto;">
                                
                                <div style="text-align: center; margin-bottom: 2rem;">
                                    <h3 style="color: #1f2937; font-size: 1.75rem; font-weight: 600; margin-bottom: 0.5rem;">
                                        💬 Communications Hub
                                    </h3>
                                    <p style="color: #6b7280; font-size: 0.875rem;">Real-time messaging with individuals and teams</p>
                                </div>
                                
                                <div style="display: grid; grid-template-columns: 350px 1fr; gap: 1.5rem; height: 650px;">
                                    
                                    <!-- Left Sidebar: Conversations -->
                                    <div style="background: white; border-radius: 0.75rem; border: 1px solid #e5e7eb; display: flex; flex-direction: column;">
                                        
                                        <!-- Header -->
                                        <div style="padding: 1.5rem; border-bottom: 1px solid #e5e7eb;">
                                            <h4 style="color: #1f2937; margin: 0 0 0.5rem; font-size: 1.125rem; font-weight: 600;">
                                                Conversations
                                            </h4>
                                            <input 
                                                type="text" 
                                                id="claws-chat-search"
                                                placeholder="Search messages..."
                                                style="width: 100%; padding: 0.5rem; border: 1px solid #d1d5db; border-radius: 0.375rem; font-size: 0.875rem;"
                                            />
                                        </div>
                                        
                                        <!-- Conversations List -->
                                        <div style="flex: 1; overflow-y: auto; padding: 0.5rem;">
                                            
                                            <!-- Teams Section -->
                                            <div style="margin-bottom: 1rem;">
                                                <div onclick="CLAWSApp.toggleChatSection('teams')" style="display: flex; justify-content: space-between; align-items: center; padding: 0.5rem; cursor: pointer; user-select: none;">
                                                    <div style="display: flex; align-items: center; gap: 0.5rem;">
                                                        <span id="claws-chat-teams-toggle" style="font-size: 0.875rem;">▼</span>
                                                        <span style="font-weight: 600; color: #6b7280; font-size: 0.75rem; text-transform: uppercase;">Teams</span>
                                                    </div>
                                                    <span id="claws-chat-teams-count" style="font-size: 0.75rem; color: #9ca3af;">0</span>
                                                </div>
                                                <div id="claws-chat-teams-list">
                                                    <!-- Teams will be loaded here -->
                                                </div>
                                            </div>
                                            
                                            <!-- Direct Messages Section -->
                                            <div>
                                                <div onclick="CLAWSApp.toggleChatSection('individuals')" style="display: flex; justify-content: space-between; align-items: center; padding: 0.5rem; cursor: pointer; user-select: none;">
                                                    <div style="display: flex; align-items: center; gap: 0.5rem;">
                                                        <span id="claws-chat-individuals-toggle" style="font-size: 0.875rem;">▼</span>
                                                        <span style="font-weight: 600; color: #6b7280; font-size: 0.75rem; text-transform: uppercase;">Direct Messages</span>
                                                    </div>
                                                    <span id="claws-chat-individuals-count" style="font-size: 0.75rem; color: #9ca3af;">0</span>
                                                </div>
                                                <div id="claws-chat-individuals-list">
                                                    <!-- Individuals will be loaded here -->
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <!-- Right Side: Chat Window -->
                                    <div style="background: white; border-radius: 0.75rem; border: 1px solid #e5e7eb; display: flex; flex-direction: column;">
                                        
                                        <!-- No Conversation Selected -->
                                        <div id="claws-chat-empty" style="flex: 1; display: flex; align-items: center; justify-content: center; color: #9ca3af;">
                                            <div style="text-align: center;">
                                                <div style="font-size: 4rem; margin-bottom: 1rem; opacity: 0.5;">💬</div>
                                                <p style="font-size: 1.125rem; margin: 0; font-weight: 500;">Select a conversation to start chatting</p>
                                                <p style="font-size: 0.875rem; margin: 0.5rem 0 0;">Choose a team or individual from the list</p>
                                            </div>
                                        </div>
                                        
                                        <!-- Active Chat (hidden until conversation selected) -->
                                        <div id="claws-chat-window" style="display: none; flex: 1; flex-direction: column;">
                                            
                                            <!-- Chat Header -->
                                            <div id="claws-chat-header" style="padding: 1.5rem; border-bottom: 1px solid #e5e7eb; background: #f9fafb;">
                                                <!-- Will be populated when chat selected -->
                                            </div>
                                            
                                            <!-- Messages Area -->
                                            <div id="claws-chat-messages" style="flex: 1; overflow-y: auto; padding: 1.5rem; background: #fafafa;">
                                                <!-- Messages will be loaded here -->
                                            </div>
                                            
                                            <!-- Message Input Area -->
                                            <div style="padding: 1.5rem; border-top: 1px solid #e5e7eb; background: white;">
                                                <div style="display: flex; gap: 0.75rem; align-items: end;">
                                                    <textarea 
                                                        id="claws-chat-input"
                                                        placeholder="Type your message..."
                                                        style="flex: 1; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 0.5rem; font-size: 0.875rem; font-family: inherit; resize: none; min-height: 44px; max-height: 120px;"
                                                        onkeydown="if(event.key === 'Enter' && !event.shiftKey) { event.preventDefault(); CLAWSApp.sendChatMessage(); }"
                                                    ></textarea>
                                                    <button 
                                                        onclick="CLAWSApp.sendChatMessage()"
                                                        class="claws-child-button"
                                                        style="border: none; padding: 0.75rem 1.5rem; border-radius: 0.5rem; font-size: 0.875rem; font-weight: 500; cursor: pointer; transition: all 0.2s; display: inline-flex; align-items: center; gap: 0.5rem; white-space: nowrap;"
                                                    >
                                                        <span>📤</span>
                                                        Send
                                                    </button>
                                                </div>
                                                <p style="margin: 0.5rem 0 0; font-size: 0.75rem; color: #9ca3af;">
                                                    Press Enter to send, Shift+Enter for new line
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Info Box -->
                                <div style="background: #f0f9ff; border: 1px solid #0ea5e9; border-radius: 0.75rem; padding: 1.5rem; margin-top: 2rem;">
                                    <h5 style="color: #0369a1; margin: 0 0 0.75rem; font-weight: 600; font-size: 1rem;">💡 How Chat Works</h5>
                                    <ul style="color: #0369a1; margin: 0; padding-left: 1.5rem; font-size: 0.875rem; line-height: 1.6;">
                                        <li><strong>Real-Time Chat:</strong> Messages appear instantly in the conversation.</li>
                                        <li><strong>Direct Messages:</strong> Click on a person's name to start a one-on-one chat.</li>
                                        <li><strong>Team Chats:</strong> Click on a team to send messages to all team members.</li>
                                        <li><strong>Message History:</strong> All messages are saved and can be viewed anytime.</li>
                                        <li><strong>Quick Send:</strong> Press Enter to send, or Shift+Enter for a new line.</li>
                                        <li><strong>Search:</strong> Use the search box to find specific conversations.</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Admin Sub-Tab -->
                        <div id="claws-volunteers-admin" class="claws-volunteers-subtab-section" style="display: none;">
                            <div style="padding: 1.5rem; max-width: 800px; margin: 0 auto;">
                                
                                <!-- Pending Task/Event Approvals Section -->
                                <div class="claws-child-header" style="border-radius: 0.75rem; padding: 1.5rem; margin-bottom: 2rem;">
                                    <h4 style="color: inherit; margin-bottom: 1rem; font-size: 1.25rem; font-weight: 600; display: flex; align-items: center;">
                                        <span style="margin-right: 0.5rem;">⏳</span> Pending Task/Event Approvals
                                    </h4>
                                    <div id="claws-admin-pending" style="margin-top: 1rem;">
                                        <p style="color: #6b7280; text-align: center; padding: 2rem;">
                                            No pending tasks to review.
                                        </p>
                                    </div>
                                </div>
                                
                                <!-- Approved Tasks and Events Section -->
                                <div class="claws-child-header" style="border-radius: 0.75rem; padding: 1.5rem;">
                                    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1rem;">
                                        <h4 style="color: inherit; margin: 0; font-size: 1.25rem; font-weight: 600; display: flex; align-items: center;">
                                            <span style="margin-right: 0.5rem;">✅</span> Approved Tasks and Events
                                        </h4>
                                        <div style="display: flex; align-items: center; gap: 0.5rem;">
                                            <span style="color: inherit; font-size: 0.875rem;">Show completed items for:</span>
                                            <select id="admin-time-filter" onchange="CLAWSApp.filterAdminApprovedItems(this.value)" style="padding: 0.375rem 0.75rem; border: 1px solid rgba(255,255,255,0.3); border-radius: 0.375rem; background: rgba(255,255,255,0.2); color: inherit; font-size: 0.875rem;">
                                                <option value="3months" selected>3 months</option>
                                                <option value="6months">6 months</option>
                                                <option value="1year">1 year</option>
                                                <option value="all">All time</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div id="claws-admin-approved" style="margin-top: 1rem;">
                                        <p style="color: #6b7280; text-align: center; padding: 2rem;">
                                            No approved tasks or events yet.
                                        </p>
                                    </div>
                                </div>
                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php else: ?>
                <!-- Upgrade Prompt for Basic Plan Users -->
                <div id="claws-volunteers-upgrade-prompt" class="claws-content-section claws-section-hidden">
                    <div style="padding: 2rem; max-width: 900px; margin: 0 auto;">
                        <div style="text-align: center; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; border-radius: 1rem; padding: 3rem 2rem; box-shadow: 0 10px 25px rgba(102, 126, 234, 0.3);">
                            <div style="font-size: 4rem; margin-bottom: 1rem; animation: pulse 2s infinite;">👥</div>
                            <h2 style="font-size: 2rem; margin-bottom: 1rem; font-weight: 700; color: white;">Volunteer Management</h2>
                            <p style="font-size: 1.125rem; margin-bottom: 2rem; opacity: 0.95; line-height: 1.6;">
                                Unlock powerful volunteer tracking, event management, team coordination, and analytics.<br/>
                                Everything you need to manage your volunteer program in one place.
                            </p>
                            
                            <!-- Feature Grid -->
                            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(180px, 1fr)); gap: 1rem; margin-bottom: 2rem; text-align: left;">
                                <div style="background: rgba(255,255,255,0.15); padding: 1.25rem; border-radius: 0.75rem; backdrop-filter: blur(10px); transition: transform 0.2s;" onmouseover="this.style.transform='translateY(-4px)'" onmouseout="this.style.transform='translateY(0)'">
                                    <div style="font-size: 2rem; margin-bottom: 0.5rem;">⏰</div>
                                    <div style="font-weight: 600; font-size: 1rem; margin-bottom: 0.25rem;">My Time</div>
                                    <div style="font-size: 0.875rem; opacity: 0.9;">Track volunteer hours and contributions</div>
                                </div>
                                <div style="background: rgba(255,255,255,0.15); padding: 1.25rem; border-radius: 0.75rem; backdrop-filter: blur(10px); transition: transform 0.2s;" onmouseover="this.style.transform='translateY(-4px)'" onmouseout="this.style.transform='translateY(0)'">
                                    <div style="font-size: 2rem; margin-bottom: 0.5rem;">🌟</div>
                                    <div style="font-weight: 600; font-size: 1rem; margin-bottom: 0.25rem;">Events</div>
                                    <div style="font-size: 0.875rem; opacity: 0.9;">Organize and manage volunteer activities</div>
                                </div>
                                <div style="background: rgba(255,255,255,0.15); padding: 1.25rem; border-radius: 0.75rem; backdrop-filter: blur(10px); transition: transform 0.2s;" onmouseover="this.style.transform='translateY(-4px)'" onmouseout="this.style.transform='translateY(0)'">
                                    <div style="font-size: 2rem; margin-bottom: 0.5rem;">👥</div>
                                    <div style="font-weight: 600; font-size: 1rem; margin-bottom: 0.25rem;">Teams</div>
                                    <div style="font-size: 0.875rem; opacity: 0.9;">Coordinate volunteer groups effectively</div>
                                </div>
                                <div style="background: rgba(255,255,255,0.15); padding: 1.25rem; border-radius: 0.75rem; backdrop-filter: blur(10px); transition: transform 0.2s;" onmouseover="this.style.transform='translateY(-4px)'" onmouseout="this.style.transform='translateY(0)'">
                                    <div style="font-size: 2rem; margin-bottom: 0.5rem;">📈</div>
                                    <div style="font-weight: 600; font-size: 1rem; margin-bottom: 0.25rem;">Stats & Goals</div>
                                    <div style="font-size: 0.875rem; opacity: 0.9;">Track progress and set milestones</div>
                                </div>
                                <div style="background: rgba(255,255,255,0.15); padding: 1.25rem; border-radius: 0.75rem; backdrop-filter: blur(10px); transition: transform 0.2s;" onmouseover="this.style.transform='translateY(-4px)'" onmouseout="this.style.transform='translateY(0)'">
                                    <div style="font-size: 2rem; margin-bottom: 0.5rem;">💬</div>
                                    <div style="font-weight: 600; font-size: 1rem; margin-bottom: 0.25rem;">Communications</div>
                                    <div style="font-size: 0.875rem; opacity: 0.9;">Team messaging and updates</div>
                                </div>
                                <div style="background: rgba(255,255,255,0.15); padding: 1.25rem; border-radius: 0.75rem; backdrop-filter: blur(10px); transition: transform 0.2s;" onmouseover="this.style.transform='translateY(-4px)'" onmouseout="this.style.transform='translateY(0)'">
                                    <div style="font-size: 2rem; margin-bottom: 0.5rem;">🔧</div>
                                    <div style="font-weight: 600; font-size: 1rem; margin-bottom: 0.25rem;">Admin</div>
                                    <div style="font-size: 0.875rem; opacity: 0.9;">Manage approvals and settings</div>
                                </div>
                            </div>
                            
                            <!-- CTA Button -->
                            <a href="<?php echo esc_url(pur_fs()->get_upgrade_url()); ?>" 
                               style="display: inline-block; background: white; color: #667eea; padding: 1rem 3rem; border-radius: 0.75rem; font-weight: 700; font-size: 1.125rem; text-decoration: none; transition: all 0.3s; box-shadow: 0 4px 12px rgba(0,0,0,0.15);"
                               onmouseover="this.style.transform='scale(1.05)'; this.style.boxShadow='0 6px 20px rgba(0,0,0,0.25)';" 
                               onmouseout="this.style.transform='scale(1)'; this.style.boxShadow='0 4px 12px rgba(0,0,0,0.15)';">
                                Upgrade to Deluxe Plan →
                            </a>
                            
                            <p style="margin-top: 1.5rem; font-size: 0.875rem; opacity: 0.8;">
                                Join hundreds of organizations managing volunteers with Purralytics
                            </p>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <?php endif; ?>
            
        </div>
    </div>
</div>

<!-- Add Colony Form Modal -->
<div id="claws-add-colony-modal" class="claws-modal-backdrop" style="display: none;">
    <div class="claws-modal">
        <div class="claws-modal-header">
            <h2 style="font-size: 1.25rem; font-weight: bold; color: #1f2937; margin: 0;">Add New Colony</h2>
            <button onclick="CLAWSApp.hideAddColonyForm()" class="claws-modal-close" style="background: none; border: none; font-size: 1.5rem; cursor: pointer; color: #6b7280; padding: 0.25rem; border-radius: 0.25rem;">×</button>
        </div>
        
        <div class="claws-modal-content" style="padding: 1rem; max-height: 70vh; overflow-y: auto;">
            <!-- Colony Name -->
            <div class="claws-form-section">
                <label class="claws-form-label">Colony Name *</label>
                <input type="text" id="claws-colony-name" class="claws-form-input" placeholder="Give this colony a name (e.g., Downtown Colony, Park Street Colony)" style="width: 100%; box-sizing: border-box;" />
            </div>

            <!-- Data Entry Date -->
            <div class="claws-form-section">
                <label class="claws-form-label">Data Entry Date</label>
                <input type="date" id="claws-colony-date" class="claws-form-input" style="width: 100%; box-sizing: border-box;" />
                <p class="description" style="margin-top: 0.5rem; font-size: 0.75rem; color: #6b7280;">
                    Set the date for this colony data entry. Use today's date for current updates.
                </p>
            </div>

            <!-- Address Information -->
            <div class="claws-form-section">
                <label class="claws-form-label">Address *</label>
                <div style="display: grid; grid-template-columns: 1fr; gap: 0.75rem;">
                    <div>
                        <input type="text" id="claws-colony-street" class="claws-form-input" placeholder="Street Address *" style="width: 100%; box-sizing: border-box;" />
                    </div>
                    <div style="display: grid; grid-template-columns: 2fr 1fr 1fr; gap: 0.5rem;">
                        <input type="text" id="claws-colony-city" class="claws-form-input" placeholder="City *" style="width: 100%; box-sizing: border-box;" />
                        <input type="text" id="claws-colony-state" class="claws-form-input" placeholder="State *" style="width: 100%; box-sizing: border-box;" />
                        <input type="text" id="claws-colony-zip" class="claws-form-input" placeholder="ZIP Code *" style="width: 100%; box-sizing: border-box;" />
                    </div>
                </div>
            </div>

            <!-- Manual Pin Placement -->
            <div class="claws-form-section">
                <label class="claws-form-label">Colony Location *</label>
                <p style="font-size: 0.875rem; color: #6b7280; margin-bottom: 0.5rem;">Click on the map below to place the colony marker at the exact location:</p>
                <div style="height: 200px; border: 1px solid #d1d5db; border-radius: 0.5rem; overflow: hidden;">
                    <div id="claws-form-map" style="height: 100%; width: 100%;"></div>
                </div>
                <div style="margin-top: 0.5rem; font-size: 0.75rem; color: #6b7280;">
                    <span>Selected coordinates: </span>
                    <span id="claws-selected-coords">Click map to select</span>
                </div>
            </div>

            <!-- Caregiver Information -->
            <div class="claws-form-section" style="background: white; border-radius: 0.75rem; padding: 1rem; box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1); border: 1px solid #e5e7eb;">
                <h3 style="font-weight: 500; color: #1f2937; margin: 0 0 0.75rem;">Caregiver Information</h3>
                <div id="claws-caregivers-container" style="width: 100%;">
                    <div class="claws-caregiver-entry" data-caregiver-index="0" style="width: 100%;">
                        <div style="margin-bottom: 0.75rem; width: 100%;">
                            <label class="claws-form-label">Caregiver Name *</label>
                            <input type="text" class="claws-form-input claws-caregiver-name" placeholder="Name of person caring for this colony" style="width: 100%; box-sizing: border-box;" />
                        </div>
                        <div style="margin-bottom: 0.75rem; width: 100%;">
                            <label class="claws-form-label">Email * (email OR phone required)</label>
                            <input type="email" class="claws-form-input claws-caregiver-email" placeholder="caregiver@example.com" style="width: 100%; box-sizing: border-box;" />
                        </div>
                        <div style="margin-bottom: 0.75rem; width: 100%;">
                            <label class="claws-form-label">Phone Number * (email OR phone required)</label>
                            <input type="tel" class="claws-form-input claws-caregiver-phone" placeholder="(555) 123-4567" style="width: 100%; box-sizing: border-box;" />
                        </div>
                        <div style="margin-bottom: 0.75rem; width: 100%;">
                            <label class="claws-form-label">Preferred Contact Method * (check all that apply)</label>
                            <div style="display: flex; flex-direction: column; gap: 0.5rem; margin-top: 0.5rem;">
                                <label style="display: flex; align-items: center; gap: 0.5rem; font-size: 0.875rem; color: #374151;">
                                    <input type="checkbox" class="claws-caregiver-contact-text" style="margin: 0; accent-color: <?php echo esc_attr(get_option('claws_primary_color', '#C1292E')); ?>;" />
                                    Text Messaging
                                </label>
                                <label style="display: flex; align-items: center; gap: 0.5rem; font-size: 0.875rem; color: #374151;">
                                    <input type="checkbox" class="claws-caregiver-contact-email" style="margin: 0; accent-color: <?php echo esc_attr(get_option('claws_primary_color', '#C1292E')); ?>;" />
                                    Email
                                </label>
                                <label style="display: flex; align-items: center; gap: 0.5rem; font-size: 0.875rem; color: #374151;">
                                    <input type="checkbox" class="claws-caregiver-contact-phone" style="margin: 0; accent-color: <?php echo esc_attr(get_option('claws_primary_color', '#C1292E')); ?>;" />
                                    Phone
                                </label>
                            </div>
                        </div>
                        <div style="margin-bottom: 0.75rem; width: 100%;">
                            <label class="claws-form-label">Make this Colony visible to (caregiver)</label>
                            <select id="claws-assign-user" class="claws-form-select" style="width: 100%; box-sizing: border-box;">
                                <option value="">Select a user to assign colony visibility...</option>
                                <?php
                                $users = get_users(array(
                                    'role__in' => array('subscriber', 'contributor', 'author', 'editor', 'administrator'),
                                    'orderby' => 'display_name'
                                ));
                                foreach ($users as $user) {
                                    echo '<option value="' . esc_attr($user->ID) . '">' . esc_html($user->display_name) . ' (' . esc_html($user->user_email) . ')</option>';
                                }
                                ?>
                            </select>
                            <p style="font-size: 0.75rem; color: #6b7280; margin: 0.25rem 0 0;">Assign colony visibility to a specific WordPress user account</p>
                        </div>
                        <div style="display: flex; flex-direction: column; gap: 0.5rem; padding-top: 0.5rem; width: 100%;">
                            <label style="display: flex; align-items: center; gap: 0.5rem; font-size: 0.875rem; color: #374151;">
                                <input type="checkbox" class="claws-caregiver-public" checked style="margin: 0; accent-color: <?php echo esc_attr(get_option('claws_primary_color', '#C1292E')); ?>;" />
                                Show contact info on app?
                            </label>
                            <button type="button" onclick="CLAWSApp.addAdditionalCaregiver()" class="claws-child-button" style="padding: 0.375rem 0.75rem; border-radius: 0.375rem; border: none; font-size: 0.75rem; cursor: pointer; align-self: flex-start; max-width: fit-content;">
                                Add additional caregiver
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Cat Population -->
            <div class="claws-form-section">
                <h3 style="font-weight: 500; color: #1f2937; margin: 0 0 0.75rem;">Cat Population * (best guess) <span style="background: #28a745; color: white; padding: 0.25rem 0.5rem; border-radius: 0.25rem; font-size: 0.75rem; font-weight: bold;">v2.0.50</span></h3>
                <p style="font-size: 0.75rem; color: #6b7280; margin: 0 0 0.75rem;">At least one cat must be listed in any age category. ✅ If all 4 columns are on ONE ROW, v2.0.50 is active!</p>
                <div style="display: grid; grid-template-columns: repeat(4, 1fr); gap: 0.75rem;">
                    <div>
                        <label class="claws-form-label">Newborn<br><span style="font-size: 0.8em; color: #6b7280; white-space: nowrap;">(0-8 weeks)</span></label>
                        <input type="number" id="claws-babies-count" class="claws-form-input" min="0" value="0" />
                    </div>
                    <div>
                        <label class="claws-form-label">Kitten<br><span style="font-size: 0.8em; color: #6b7280; white-space: nowrap;">(2-5 months)</span></label>
                        <input type="number" id="claws-kittens-count" class="claws-form-input" min="0" value="0" />
                    </div>
                    <div>
                        <label class="claws-form-label">Cat<br><span style="font-size: 0.8em; color: #6b7280; white-space: nowrap;">(6 months-8 years)</span></label>
                        <input type="number" id="claws-adults-count" class="claws-form-input" min="0" value="0" />
                    </div>
                    <div>
                        <label class="claws-form-label">Senior<br><span style="font-size: 0.8em; color: #6b7280; white-space: nowrap;">(8+ years)</span></label>
                        <input type="number" id="claws-seniors-count" class="claws-form-input" min="0" value="0" />
                    </div>
                </div>
                <div style="margin-top: 1rem; padding-top: 0.75rem; border-top: 1px solid #e5e7eb;">
                    <div style="display: flex; justify-content: space-between; align-items: center;">
                        <span style="font-size: 0.875rem; font-weight: 500; color: #374151;">Total Cats:</span>
                        <span style="font-size: 1.125rem; font-weight: bold; color: #C7644D;" id="claws-total-cats-display">0</span>
                    </div>
                </div>
            </div>

            <!-- Colony Health Metrics -->
            <div class="claws-form-section">
                <h3 style="font-weight: 500; color: #1f2937; margin: 0 0 0.75rem;">Colony Health Metrics</h3>
                
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1rem; margin-bottom: 1rem;">
                    <!-- TNR Progress -->
                    <div>
                        <label class="claws-form-label">Tipped Ears (TNR'd cats) *</label>
                        <input type="number" id="claws-tipped-ears" class="claws-form-input" min="0" placeholder="0" />
                        
                        <!-- TNR without ear tipping checkbox -->
                        <div style="margin-top: 0.75rem;">
                            <label style="display: flex; align-items: center; gap: 0.5rem; font-size: 0.875rem; color: #374151;">
                                <input type="checkbox" id="claws-tnr-no-tipping" style="margin: 0; accent-color: <?php echo esc_attr(get_option('claws_primary_color', '#C1292E')); ?>;" />
                                Some cats may have been TNR'd, but no ear tipping
                            </label>
                        </div>
                        
                        <div style="margin-top: 0.5rem;">
                            <div style="display: flex; justify-content: space-between; font-size: 0.75rem; color: #6b7280; margin-bottom: 0.25rem;">
                                <span>TNR Progress</span>
                                <span id="claws-tnr-percentage">0%</span>
                            </div>
                            <div style="width: 100%; background: #e5e7eb; border-radius: 9999px; height: 0.5rem;">
                                <div id="claws-tnr-progress-bar" style="height: 0.5rem; border-radius: 9999px; width: 0%; background: #d1d5db; transition: width 0.3s ease-in-out;"></div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Shelter Coverage -->
                    <div>
                        <label class="claws-form-label">Winter Shelters *</label>
                        <input type="number" id="claws-winter-shelters" class="claws-form-input" min="0" placeholder="0" />
                        <div style="margin-top: 0.5rem;">
                            <div style="display: flex; justify-content: space-between; font-size: 0.75rem; color: #6b7280; margin-bottom: 0.25rem;">
                                <span>Shelter Coverage</span>
                                <span id="claws-shelter-percentage">0%</span>
                            </div>
                            <div style="width: 100%; background: #e5e7eb; border-radius: 9999px; height: 0.5rem;">
                                <div id="claws-shelter-progress-bar" style="height: 0.5rem; border-radius: 9999px; width: 0%; background: #d1d5db; transition: width 0.3s ease-in-out;"></div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Security Selects -->
                <div style="display: flex; flex-direction: column; gap: 1rem;">
                    <div>
                        <label class="claws-form-label">Food Security *</label>
                        <select id="claws-food-security" class="claws-form-select">
                            <option value="">Select food security level</option>
                            <option value="Insufficient">Insufficient</option>
                            <option value="Marginal">Marginal</option>
                            <option value="Sufficient">Sufficient</option>
                            <option value="Good">Good</option>
                            <option value="Very Good">Very Good</option>
                        </select>
                    </div>
                    
                    <div>
                        <label class="claws-form-label">Water Security *</label>
                        <select id="claws-water-security" class="claws-form-select">
                            <option value="">Select water security level</option>
                            <option value="Insufficient">Insufficient</option>
                            <option value="Marginal">Marginal</option>
                            <option value="Sufficient">Sufficient</option>
                            <option value="Good">Good</option>
                            <option value="Very Good">Very Good</option>
                        </select>
                    </div>
                    
                    <div>
                        <label class="claws-form-label">Safe Location *</label>
                        <select id="claws-safe-location" class="claws-form-select">
                            <option value="">Select safety level</option>
                            <option value="Dangerous">Dangerous</option>
                            <option value="Unsafe">Unsafe</option>
                            <option value="Somewhat Safe">Somewhat Safe</option>
                            <option value="Safe">Safe</option>
                            <option value="Very Safe">Very Safe</option>
                        </select>
                    </div>
                </div>

                <!-- Total Health Score -->
                <div style="padding-top: 0.75rem; border-top: 1px solid #e5e7eb; margin-top: 1rem;">
                    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 0.5rem;">
                        <span style="font-size: 0.875rem; font-weight: 500; color: #374151;">Total Colony Health:</span>
                        <span style="font-size: 1.125rem; font-weight: bold; color: #C7644D;" id="claws-total-health-score">0%</span>
                    </div>
                    <div style="width: 100%; background: #e5e7eb; border-radius: 9999px; height: 0.75rem;">
                        <div id="claws-total-health-bar" style="height: 0.75rem; border-radius: 9999px; width: 0%; background: #d1d5db; transition: width 0.3s ease-in-out;"></div>
                    </div>
                </div>
            </div>

            <!-- Additional Colony Information -->
            <div class="claws-form-section">
                <h3 style="font-weight: 500; color: #1f2937; margin: 0 0 0.75rem;">Additional Colony Information</h3>
                
                <div style="display: grid; grid-template-columns: 1fr; gap: 1rem;">
                    <!-- Capture Method -->
                    <div>
                        <label class="claws-form-label">How do you think the cats will need to be captured?</label>
                        <select id="claws-capture-method" class="claws-form-select">
                            <option value="">Select capture method...</option>
                            <option value="Trap">Trap</option>
                            <option value="Put in carrier">Put in carrier</option>
                        </select>
                    </div>
                    
                    <!-- Vaccination Count -->
                    <div>
                        <label class="claws-form-label">Number of cats that have been vaccinated (rabies)?</label>
                        <input type="number" id="claws-vaccinated-count" class="claws-form-input" min="0" placeholder="Leave blank if unknown" />
                        <p style="font-size: 0.75rem; color: #6b7280; margin: 0.25rem 0 0;">If left blank, the system will record "unknown"</p>
                    </div>
                    
                    <!-- Microchip Count -->
                    <div>
                        <label class="claws-form-label">How many are microchipped?</label>
                        <input type="number" id="claws-microchip-count" class="claws-form-input" min="0" placeholder="Leave blank if unknown" />
                        <p style="font-size: 0.75rem; color: #6b7280; margin: 0.25rem 0 0;">If left blank, the system will record "unknown"</p>
                    </div>
                </div>
                
                <!-- TNR Volunteer Help Section -->
                <div style="margin-top: 1.5rem; padding: 1rem; background: #f9fafb; border-radius: 0.75rem; border: 1px solid #e5e7eb;">
                    <h4 style="font-weight: 500; color: #1f2937; margin: 0 0 0.75rem; font-size: 1rem;">How will you help with your TNR?</h4>
                    <p style="font-size: 0.875rem; color: #6b7280; margin: 0 0 1rem;">Reminder, we are a small team made up of all volunteer members. We have limited time and need to spend that time as efficiently as possible and we are always working a sizable backlog of requests. (check all that apply)</p>
                    
                    <div style="display: grid; grid-template-columns: 1fr; gap: 0.5rem;">
                        <label style="display: flex; align-items: flex-start; gap: 0.5rem; font-size: 0.875rem; color: #374151;">
                            <input type="checkbox" id="claws-help-feed" style="margin: 0.125rem 0 0 0; accent-color: <?php echo esc_attr(get_option('claws_primary_color', '#C1292E')); ?>; flex-shrink: 0;" />
                            <span>Feed cats on a regular schedule leading up to trapping</span>
                        </label>
                        
                        <label style="display: flex; align-items: flex-start; gap: 0.5rem; font-size: 0.875rem; color: #374151;">
                            <input type="checkbox" id="claws-help-trap" style="margin: 0.125rem 0 0 0; accent-color: <?php echo esc_attr(get_option('claws_primary_color', '#C1292E')); ?>; flex-shrink: 0;" />
                            <span>Trap cats (with guidance and supplies)</span>
                        </label>
                        
                        <label style="display: flex; align-items: flex-start; gap: 0.5rem; font-size: 0.875rem; color: #374151;">
                            <input type="checkbox" id="claws-help-house-pre" style="margin: 0.125rem 0 0 0; accent-color: <?php echo esc_attr(get_option('claws_primary_color', '#C1292E')); ?>; flex-shrink: 0;" />
                            <span>House cats overnight in traps pre op</span>
                        </label>
                        
                        <label style="display: flex; align-items: flex-start; gap: 0.5rem; font-size: 0.875rem; color: #374151;">
                            <input type="checkbox" id="claws-help-transport-to" style="margin: 0.125rem 0 0 0; accent-color: <?php echo esc_attr(get_option('claws_primary_color', '#C1292E')); ?>; flex-shrink: 0;" />
                            <span>Transport cats (in traps) to clinic</span>
                        </label>
                        
                        <label style="display: flex; align-items: flex-start; gap: 0.5rem; font-size: 0.875rem; color: #374151;">
                            <input type="checkbox" id="claws-help-transport-from" style="margin: 0.125rem 0 0 0; accent-color: <?php echo esc_attr(get_option('claws_primary_color', '#C1292E')); ?>; flex-shrink: 0;" />
                            <span>Transport cats (in carriers) from clinic</span>
                        </label>
                        
                        <label style="display: flex; align-items: flex-start; gap: 0.5rem; font-size: 0.875rem; color: #374151;">
                            <input type="checkbox" id="claws-help-recovery" style="margin: 0.125rem 0 0 0; accent-color: <?php echo esc_attr(get_option('claws_primary_color', '#C1292E')); ?>; flex-shrink: 0;" />
                            <span>Prepare area for cats to recover from surgery</span>
                        </label>
                        
                        <label style="display: flex; align-items: flex-start; gap: 0.5rem; font-size: 0.875rem; color: #374151;">
                            <input type="checkbox" id="claws-help-monitor" style="margin: 0.125rem 0 0 0; accent-color: <?php echo esc_attr(get_option('claws_primary_color', '#C1292E')); ?>; flex-shrink: 0;" />
                            <span>Keep cats (in carriers) overnight and monitor</span>
                        </label>
                        
                        <label style="display: flex; align-items: flex-start; gap: 0.5rem; font-size: 0.875rem; color: #374151;">
                            <input type="checkbox" id="claws-help-return" style="margin: 0.125rem 0 0 0; accent-color: <?php echo esc_attr(get_option('claws_primary_color', '#C1292E')); ?>; flex-shrink: 0;" />
                            <span>Return cats to their home and release</span>
                        </label>
                        
                        <label style="display: flex; align-items: flex-start; gap: 0.5rem; font-size: 0.875rem; color: #374151;">
                            <input type="checkbox" id="claws-help-watch" style="margin: 0.125rem 0 0 0; accent-color: <?php echo esc_attr(get_option('claws_primary_color', '#C1292E')); ?>; flex-shrink: 0;" />
                            <span>Watch for new cats and get them in for spay/neuter</span>
                        </label>
                        
                        <label style="display: flex; align-items: flex-start; gap: 0.5rem; font-size: 0.875rem; color: #374151;">
                            <input type="checkbox" id="claws-help-donate" style="margin: 0.125rem 0 0 0; accent-color: <?php echo esc_attr(get_option('claws_primary_color', '#C1292E')); ?>; flex-shrink: 0;" />
                            <span>Donate money for surgeries</span>
                        </label>
                    </div>
                    
                </div>

                <!-- Colony Help Section -->
                <div style="margin-top: 1.5rem; padding: 1rem; background: #fff3cd; border: 3px solid #ff0000; border-radius: 0.75rem;">
                    <h4 style="font-weight: 700; color: #ff0000; margin: 0 0 0.75rem; font-size: 1.25rem;">🚨 Colony Help: I need assistance with 🚨</h4>
                    <p style="font-size: 0.875rem; color: #856404; margin: 0 0 1rem; font-weight: 600;">⚠️ If you can see this section, version 2.0.50 is active! ⚠️</p>
                    <p style="font-size: 0.875rem; color: #6b7280; margin: 0 0 1rem;">(select all that apply)</p>
                    
                    <div id="claws-colony-help-options" style="display: grid; grid-template-columns: 1fr; gap: 0.5rem;">
                        <?php
                        $colony_help_options = get_option('claws_colony_help_options', array(
                            'traps' => array('label' => 'Traps or other equipment', 'email' => ''),
                            'trapping' => array('label' => 'Trapping', 'email' => ''),
                            'appointments' => array('label' => 'Spay/neuter appointments', 'email' => ''),
                            'food' => array('label' => 'Cat food', 'email' => ''),
                            'caretaking' => array('label' => 'Caretaking assistance', 'email' => ''),
                            'shelters' => array('label' => 'Winter shelters', 'email' => '')
                        ));
                        
                        $option_count = 0;
                        foreach ($colony_help_options as $key => $option):
                            // Handle both array format and string format
                            $label = '';
                            if (is_array($option) && !empty($option['label'])) {
                                $label = $option['label'];
                            } elseif (is_string($option)) {
                                $label = $option;
                            }
                            
                            if (!empty($label)):
                                $option_count++;
                        ?>
                        <label style="display: flex; align-items: flex-start; gap: 0.5rem; font-size: 0.875rem; color: #374151;">
                            <input type="checkbox" class="claws-help-option" data-help-type="<?php echo esc_attr($key); ?>" style="margin: 0.125rem 0 0 0; accent-color: <?php echo esc_attr(get_option('claws_primary_color', '#C1292E')); ?>; flex-shrink: 0;" />
                            <span><?php echo esc_html($label); ?></span>
                        </label>
                        <?php
                            endif;
                        endforeach;
                        
                        // If no options rendered, show a message
                        if ($option_count === 0):
                        ?>
                        <p style="color: #dc3545; font-size: 1rem; font-weight: bold; padding: 1rem; background: #f8d7da; border-radius: 0.5rem;">
                            ⚠️ No help options configured. Please contact your administrator to set up colony help options in Settings → Purralytics → Colony tab.
                        </p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Form Buttons -->
            <div style="display: flex; gap: 0.75rem; padding-top: 1rem;">
                <button onclick="CLAWSApp.hideAddColonyForm()" class="claws-btn claws-btn-secondary" style="flex: 1;">Cancel</button>
                <button onclick="CLAWSApp.saveColony()" class="claws-btn claws-btn-primary" style="flex: 1;">Save Colony</button>
            </div>
        </div>
    </div>
</div>

<!-- Add Event Form Modal -->
<div id="claws-add-event-modal" class="claws-modal-backdrop" style="display: none;">
    <div class="claws-modal">
        <div class="claws-modal-header">
            <h2 style="font-size: 1.25rem; font-weight: bold; color: #1f2937; margin: 0;">Create New Event</h2>
            <button onclick="CLAWSApp.hideAddEventForm()" class="claws-modal-close" style="background: none; border: none; font-size: 1.5rem; cursor: pointer; color: #6b7280; padding: 0.25rem; border-radius: 0.25rem;">×</button>
        </div>

        <div class="claws-modal-body" style="padding: 1.5rem; max-height: 70vh; overflow-y: auto;">
            
            <!-- Event Basic Information -->
            <div class="claws-form-section" style="margin-bottom: 1.5rem; padding: 1rem; background: #f9fafb; border-radius: 0.75rem; border: 1px solid #e5e7eb;">
                <h3 style="font-weight: 500; color: #1f2937; margin: 0 0 1rem; font-size: 1rem;">Event Details</h3>
                
                <div style="margin-bottom: 1rem;">
                    <label class="claws-form-label" for="claws-event-name">Name of Event *</label>
                    <input type="text" id="claws-event-name" placeholder="e.g., Saturday Morning Colony Feeding" style="width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 0.5rem; font-size: 0.875rem;" required />
                </div>
                
                <div style="margin-bottom: 1rem;">
                    <label class="claws-form-label" for="claws-event-category">Category of Need *</label>
                    <select id="claws-event-category" style="width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 0.5rem; font-size: 0.875rem;" required>
                        <option value="">Select category...</option>
                        <!-- Categories will be populated by JavaScript using unified types -->
                    </select>
                </div>
                
                <!-- Colony Selection (for Colony Care and TNR Party categories) -->
                <div id="claws-event-colony-section" style="margin-bottom: 1rem; display: none;">
                    <label class="claws-form-label" for="claws-event-colony">Select Colony *</label>
                    <select id="claws-event-colony" style="width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 0.5rem; font-size: 0.875rem;">
                        <option value="">Choose a colony...</option>
                        <!-- Colonies will be populated dynamically -->
                    </select>
                    <p style="font-size: 0.75rem; color: #6b7280; margin: 0.25rem 0 0;">Select which colony this event applies to</p>
                </div>
                
                <!-- TNR Not At Colony Option (only for TNR Party) -->
                <div id="claws-event-tnr-not-colony-section" style="margin-bottom: 1rem; display: none;">
                    <label style="display: flex; align-items: center; gap: 0.5rem; font-size: 0.875rem; color: #374151; cursor: pointer;">
                        <input type="checkbox" id="claws-event-tnr-not-colony" style="margin: 0; accent-color: <?php echo esc_attr(get_option('claws_primary_color', '#C1292E')); ?>;" />
                        <span style="font-weight: 500;">TNR, Not At A Colony</span>
                    </label>
                    <p style="font-size: 0.75rem; color: #6b7280; margin: 0.25rem 0 0 1.5rem;">Check this if the TNR will happen at a different location</p>
                </div>
                
                <!-- Custom Address Section (for TNR not at colony or Colony Care with selected colony) -->
                <div id="claws-event-address-section" style="margin-bottom: 1rem; display: none;">
                    <label class="claws-form-label">Location Address</label>
                    
                    <div style="margin-bottom: 0.75rem;">
                        <input type="text" id="claws-event-street" placeholder="Street Address" style="width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 0.5rem; font-size: 0.875rem;" />
                    </div>
                    
                    <div style="display: grid; grid-template-columns: 2fr 1fr 1fr; gap: 0.75rem;">
                        <div>
                            <input type="text" id="claws-event-city" placeholder="City" style="width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 0.5rem; font-size: 0.875rem;" />
                        </div>
                        <div>
                            <input type="text" id="claws-event-state" placeholder="State" style="width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 0.5rem; font-size: 0.875rem;" />
                        </div>
                        <div>
                            <input type="text" id="claws-event-zip" placeholder="ZIP" style="width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 0.5rem; font-size: 0.875rem;" />
                        </div>
                    </div>
                    <p style="font-size: 0.75rem; color: #6b7280; margin: 0.25rem 0 0;">Provide the specific location where volunteers should meet</p>
                </div>
            </div>

            <!-- Date and Time Information -->
            <div class="claws-form-section" style="margin-bottom: 1.5rem; padding: 1rem; background: #f9fafb; border-radius: 0.75rem; border: 1px solid #e5e7eb;">
                <h3 style="font-weight: 500; color: #1f2937; margin: 0 0 1rem; font-size: 1rem;">Schedule</h3>
                
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1rem; margin-bottom: 1rem;">
                    <div>
                        <label class="claws-form-label" for="claws-event-date">Date of Event *</label>
                        <input type="date" id="claws-event-date" style="width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 0.5rem; font-size: 0.875rem;" required />
                    </div>
                    <div>
                        <label class="claws-form-label" for="claws-event-min-commitment">Minimum Time Commitment</label>
                        <select id="claws-event-min-commitment" style="width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 0.5rem; font-size: 0.875rem;">
                            <option value="">Select minimum...</option>
                            <option value="30min">30 minutes</option>
                            <option value="1hr">1 hour</option>
                            <option value="2hr">2 hours</option>
                            <option value="3hr">3 hours</option>
                            <option value="4hr">4 hours</option>
                            <option value="half-day">Half day (4+ hours)</option>
                            <option value="full-day">Full day (8+ hours)</option>
                            <option value="flexible">Flexible</option>
                        </select>
                    </div>
                </div>
                
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1rem;">
                    <div>
                        <label class="claws-form-label" for="claws-event-start-time">Start Time</label>
                        <input type="time" id="claws-event-start-time" style="width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 0.5rem; font-size: 0.875rem;" />
                    </div>
                    <div>
                        <label class="claws-form-label" for="claws-event-end-time">End Time</label>
                        <input type="time" id="claws-event-end-time" style="width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 0.5rem; font-size: 0.875rem;" />
                    </div>
                </div>
            </div>

            <!-- Coordinator Information -->
            <div class="claws-form-section" style="margin-bottom: 1.5rem; padding: 1rem; background: #f9fafb; border-radius: 0.75rem; border: 1px solid #e5e7eb;">
                <h3 style="font-weight: 500; color: #1f2937; margin: 0 0 1rem; font-size: 1rem;">Coordinator Information</h3>
                
                <div style="margin-bottom: 1rem;">
                    <label class="claws-form-label" for="claws-event-coordinator">Coordinator Name</label>
                    <input type="text" id="claws-event-coordinator" placeholder="Coordinator name" style="width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 0.5rem; font-size: 0.875rem;" />
                    <p style="font-size: 0.75rem; color: #6b7280; margin: 0.25rem 0 0;">Auto-populated from your profile, but can be changed</p>
                </div>
                
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1rem;">
                    <div>
                        <label class="claws-form-label" for="claws-event-email">Email</label>
                        <input type="email" id="claws-event-email" placeholder="coordinator@example.com" style="width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 0.5rem; font-size: 0.875rem;" />
                    </div>
                    <div>
                        <label class="claws-form-label" for="claws-event-phone">Phone Number</label>
                        <input type="tel" id="claws-event-phone" placeholder="(555) 123-4567" style="width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 0.5rem; font-size: 0.875rem;" />
                    </div>
                </div>
            </div>

            <!-- Event Lead Section -->
            <div class="claws-form-section" style="margin-bottom: 1.5rem; padding: 1rem; background: #fef3c7; border-radius: 0.75rem; border: 1px solid #f59e0b;">
                <h3 style="font-weight: 500; color: #1f2937; margin: 0 0 1rem; font-size: 1rem;">⭐ Event Lead</h3>
                
                <div>
                    <label class="claws-form-label" for="claws-event-lead">Assign Event Lead *</label>
                    <select id="claws-event-lead" style="width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 0.5rem; font-size: 0.875rem;" required>
                        <option value="">Select event lead...</option>
                        <!-- Will be populated with all volunteers by JavaScript -->
                    </select>
                    <p style="font-size: 0.75rem; color: #6b7280; margin: 0.25rem 0 0;">Who will lead and coordinate this event?</p>
                </div>
            </div>

            <!-- Volunteer Spots Section -->
            <div class="claws-form-section" style="margin-bottom: 1.5rem; padding: 1rem; background: #f0f9ff; border-radius: 0.75rem; border: 1px solid #0ea5e9;">
                <h3 style="font-weight: 500; color: #1f2937; margin: 0 0 1rem; font-size: 1rem;">👥 Volunteer Spots</h3>
                
                <div style="margin-bottom: 1rem;">
                    <label class="claws-form-label" for="claws-event-num-volunteers">Number of Volunteers Needed *</label>
                    <input type="number" id="claws-event-num-volunteers" min="1" max="50" value="1" onchange="CLAWSApp.updateVolunteerSpots()" style="width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 0.5rem; font-size: 0.875rem;" required />
                    <p style="font-size: 0.75rem; color: #6b7280; margin: 0.25rem 0 0;">How many volunteers do you need for this event?</p>
                </div>
                
                <!-- Dynamic Spots Container -->
                <div id="claws-volunteer-spots-container" style="margin-top: 1rem;">
                    <!-- Spots will be generated dynamically by JavaScript -->
                </div>
            </div>

            <!-- Notes Section -->
            <div class="claws-form-section" style="margin-bottom: 1.5rem; padding: 1rem; background: #f9fafb; border-radius: 0.75rem; border: 1px solid #e5e7eb;">
                <h3 style="font-weight: 500; color: #1f2937; margin: 0 0 1rem; font-size: 1rem;">Additional Details</h3>
                
                <div>
                    <label class="claws-form-label" for="claws-event-notes">Notes (Optional)</label>
                    <textarea id="claws-event-notes" rows="4" placeholder="Explain what needs to be done, goals of the event, special requirements, what volunteers should bring, etc." style="width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 0.5rem; font-size: 0.875rem; resize: vertical;"></textarea>
                    <p style="font-size: 0.75rem; color: #6b7280; margin: 0.25rem 0 0;">Provide details about the task, requirements, and expectations</p>
                </div>
            </div>

            <!-- Form Buttons -->
            <div style="display: flex; gap: 0.75rem; padding-top: 1rem; border-top: 1px solid #e5e7eb;">
                <button onclick="CLAWSApp.hideAddEventForm()" class="claws-btn claws-btn-secondary" style="flex: 1;">Cancel</button>
                <button onclick="CLAWSApp.saveEvent()" class="claws-btn claws-btn-primary" style="flex: 1;">Create Event</button>
            </div>
        </div>
    </div>
</div>

<!-- Add Project Form Modal -->
<div id="claws-add-project-modal" class="claws-modal-backdrop" style="display: none;">
    <div class="claws-modal">
        <div class="claws-modal-header">
            <h2 style="font-size: 1.25rem; font-weight: bold; color: #1f2937; margin: 0;">Create New Project</h2>
            <button onclick="CLAWSApp.hideAddProjectForm()" class="claws-modal-close" style="background: none; border: none; font-size: 1.5rem; cursor: pointer; color: #6b7280; padding: 0.25rem; border-radius: 0.25rem;">×</button>
        </div>

        <div class="claws-modal-body" style="padding: 1.5rem; max-height: 70vh; overflow-y: auto;">
            
            <!-- Project Basic Information -->
            <div class="claws-form-section" style="margin-bottom: 1.5rem; padding: 1rem; background: #f9fafb; border-radius: 0.75rem; border: 1px solid #e5e7eb;">
                <h3 style="font-weight: 500; color: #1f2937; margin: 0 0 1rem; font-size: 1rem;">Project Details</h3>
                
                <div style="margin-bottom: 1rem;">
                    <label class="claws-form-label" for="claws-project-name">Name of Project *</label>
                    <input type="text" id="claws-project-name" placeholder="e.g., Colony Care Support for Mrs. Gruder" style="width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 0.5rem; font-size: 0.875rem;" required />
                </div>
                
                <div style="margin-bottom: 1rem;">
                    <label class="claws-form-label" for="claws-project-category">Category of Need *</label>
                    <select id="claws-project-category" style="width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 0.5rem; font-size: 0.875rem;" required>
                        <option value="">Select category...</option>
                        <!-- Categories will be populated by JavaScript using unified types -->
                    </select>
                </div>
                
                <!-- Colony Selection (for Colony Care and TNR Party categories) -->
                <div id="claws-project-colony-section" style="margin-bottom: 1rem; display: none;">
                    <label class="claws-form-label" for="claws-project-colony">Select Colony *</label>
                    <select id="claws-project-colony" style="width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 0.5rem; font-size: 0.875rem;">
                        <option value="">Choose a colony...</option>
                        <!-- Colonies will be populated dynamically -->
                    </select>
                    <p style="font-size: 0.75rem; color: #6b7280; margin: 0.25rem 0 0;">Select which colony this project applies to</p>
                </div>
                
                <!-- TNR Not At Colony Option (only for TNR Party) -->
                <div id="claws-project-tnr-not-colony-section" style="margin-bottom: 1rem; display: none;">
                    <label style="display: flex; align-items: center; gap: 0.5rem; font-size: 0.875rem; color: #374151; cursor: pointer;">
                        <input type="checkbox" id="claws-project-tnr-not-colony" style="margin: 0; accent-color: <?php echo esc_attr(get_option('claws_primary_color', '#C1292E')); ?>;" />
                        <span style="font-weight: 500;">TNR, Not At A Colony</span>
                    </label>
                    <p style="font-size: 0.75rem; color: #6b7280; margin: 0.25rem 0 0 1.5rem;">Check this if the TNR will happen at a different location</p>
                </div>
                
                <!-- Custom Address Section (for TNR not at colony or Colony Care with selected colony) -->
                <div id="claws-project-address-section" style="margin-bottom: 1rem; display: none;">
                    <label class="claws-form-label">Location Address</label>
                    
                    <div style="margin-bottom: 0.75rem;">
                        <input type="text" id="claws-project-street" placeholder="Street Address" style="width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 0.5rem; font-size: 0.875rem;" />
                    </div>
                    
                    <div style="display: grid; grid-template-columns: 2fr 1fr 1fr; gap: 0.75rem;">
                        <div>
                            <input type="text" id="claws-project-city" placeholder="City" style="width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 0.5rem; font-size: 0.875rem;" />
                        </div>
                        <div>
                            <input type="text" id="claws-project-state" placeholder="State" style="width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 0.5rem; font-size: 0.875rem;" />
                        </div>
                        <div>
                            <input type="text" id="claws-project-zip" placeholder="ZIP" style="width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 0.5rem; font-size: 0.875rem;" />
                        </div>
                    </div>
                    <p style="font-size: 0.75rem; color: #6b7280; margin: 0.25rem 0 0;">Provide the location for this ongoing project</p>
                </div>
            </div>

            <!-- NO DATE/TIME SECTION FOR PROJECTS - They're ongoing! -->

            <!-- Coordinator Information -->
            <div class="claws-form-section" style="margin-bottom: 1.5rem; padding: 1rem; background: #f9fafb; border-radius: 0.75rem; border: 1px solid #e5e7eb;">
                <h3 style="font-weight: 500; color: #1f2937; margin: 0 0 1rem; font-size: 1rem;">Coordinator Information</h3>
                
                <div style="margin-bottom: 1rem;">
                    <label class="claws-form-label" for="claws-project-coordinator">Coordinator Name</label>
                    <input type="text" id="claws-project-coordinator" placeholder="Coordinator name" style="width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 0.5rem; font-size: 0.875rem;" />
                    <p style="font-size: 0.75rem; color: #6b7280; margin: 0.25rem 0 0;">Auto-populated from your profile, but can be changed</p>
                </div>
                
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1rem;">
                    <div>
                        <label class="claws-form-label" for="claws-project-email">Email</label>
                        <input type="email" id="claws-project-email" placeholder="coordinator@example.com" style="width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 0.5rem; font-size: 0.875rem;" />
                    </div>
                    <div>
                        <label class="claws-form-label" for="claws-project-phone">Phone Number</label>
                        <input type="tel" id="claws-project-phone" placeholder="(555) 123-4567" style="width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 0.5rem; font-size: 0.875rem;" />
                    </div>
                </div>
            </div>

            <!-- Project Lead Section -->
            <div class="claws-form-section" style="margin-bottom: 1.5rem; padding: 1rem; background: #fef3c7; border-radius: 0.75rem; border: 1px solid #f59e0b;">
                <h3 style="font-weight: 500; color: #1f2937; margin: 0 0 1rem; font-size: 1rem;">⭐ Project Lead</h3>
                
                <div>
                    <label class="claws-form-label" for="claws-project-lead">Assign Project Lead *</label>
                    <select id="claws-project-lead" style="width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 0.5rem; font-size: 0.875rem;" required>
                        <option value="">Select project lead...</option>
                        <!-- Will be populated with all volunteers by JavaScript -->
                    </select>
                    <p style="font-size: 0.75rem; color: #6b7280; margin: 0.25rem 0 0;">Who will lead and coordinate this project?</p>
                </div>
            </div>

            <!-- Volunteer Spots Section -->
            <div class="claws-form-section" style="margin-bottom: 1.5rem; padding: 1rem; background: #f0f9ff; border-radius: 0.75rem; border: 1px solid #0ea5e9;">
                <h3 style="font-weight: 500; color: #1f2937; margin: 0 0 1rem; font-size: 1rem;">👥 Volunteer Spots</h3>
                
                <div style="margin-bottom: 1rem;">
                    <label class="claws-form-label" for="claws-project-num-volunteers">Number of Volunteers Needed *</label>
                    <input type="number" id="claws-project-num-volunteers" min="1" max="50" value="1" onchange="CLAWSApp.updateProjectVolunteerSpots()" style="width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 0.5rem; font-size: 0.875rem;" required />
                    <p style="font-size: 0.75rem; color: #6b7280; margin: 0.25rem 0 0;">How many volunteers do you need for this project?</p>
                </div>
                
                <!-- Dynamic Spots Container -->
                <div id="claws-project-volunteer-spots-container" style="margin-top: 1rem;">
                    <!-- Spots will be generated dynamically by JavaScript -->
                </div>
            </div>

            <!-- Notes Section -->
            <div class="claws-form-section" style="margin-bottom: 1.5rem; padding: 1rem; background: #f9fafb; border-radius: 0.75rem; border: 1px solid #e5e7eb;">
                <h3 style="font-weight: 500; color: #1f2937; margin: 0 0 1rem; font-size: 1rem;">Additional Details</h3>
                
                <div>
                    <label class="claws-form-label" for="claws-project-notes">Notes (Optional)</label>
                    <textarea id="claws-project-notes" rows="4" placeholder="Explain what needs to be done, goals of the project, special requirements, what volunteers should bring, etc." style="width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 0.5rem; font-size: 0.875rem; resize: vertical;"></textarea>
                    <p style="font-size: 0.75rem; color: #6b7280; margin: 0.25rem 0 0;">Provide details about the project, requirements, and expectations</p>
                </div>
            </div>

            <!-- Form Buttons -->
            <div style="display: flex; gap: 0.75rem; padding-top: 1rem; border-top: 1px solid #e5e7eb;">
                <button onclick="CLAWSApp.hideAddProjectForm()" class="claws-btn claws-btn-secondary" style="flex: 1;">Cancel</button>
                <button onclick="CLAWSApp.saveProject()" class="claws-btn claws-btn-primary" style="flex: 1;">Create Project</button>
            </div>
        </div>
    </div>
</div>

<!-- Decline Reservation Modal -->
<div id="claws-decline-modal" class="claws-modal-backdrop" style="display: none;">
    <div class="claws-modal" style="max-width: 500px;">
        <div class="claws-modal-header">
            <h3>✗ Decline Reserved Spot</h3>
            <button onclick="CLAWSApp.hideDeclineModal()" class="claws-modal-close" style="background: none; border: none; font-size: 1.5rem; cursor: pointer; color: #6b7280; padding: 0.25rem; border-radius: 0.25rem;">×</button>
        </div>
        
        <div class="claws-modal-content" style="padding: 1.5rem;">
            <input type="hidden" id="decline-event-id" />
            
            <p style="margin-bottom: 1rem; color: #374151;">
                Please let the event coordinator know why you need to decline this reservation:
            </p>
            
            <textarea 
                id="decline-note" 
                placeholder="I have a conflict that day..." 
                style="width: 100%; box-sizing: border-box; min-height: 100px; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 0.5rem; font-size: 0.875rem; font-family: inherit; resize: vertical;"
            ></textarea>
            
            <div style="background: #f0f9ff; border: 1px solid #0ea5e9; border-radius: 0.5rem; padding: 0.75rem; margin-top: 1rem;">
                <p style="margin: 0; font-size: 0.875rem; color: #0369a1;">
                    <strong>Note:</strong> This message will be sent to <span id="decline-coordinator-name">the event coordinator</span>.
                </p>
            </div>
            
            <div style="display: flex; gap: 0.75rem; margin-top: 1.5rem;">
                <button onclick="CLAWSApp.hideDeclineModal()" style="flex: 1; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 0.5rem; background: white; color: #374151; font-weight: 500; cursor: pointer;">
                    Cancel
                </button>
                <button onclick="CLAWSApp.submitDecline()" style="flex: 1; padding: 0.75rem; border: none; border-radius: 0.5rem; background: linear-gradient(135deg, #ef4444, #dc2626); color: white; font-weight: 600; cursor: pointer;">
                    Send & Decline
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Loading Indicator -->
<div id="claws-loading" style="position: fixed; top: 0; left: 0; right: 0; bottom: 0; background: rgba(0,0,0,0.5); display: none; z-index: 9999; backdrop-filter: blur(4px);">
    <div style="position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); background: white; padding: 2rem; border-radius: 1rem; text-align: center;">
        <div style="width: 2rem; height: 2rem; border: 3px solid #f3f4f6; border-top: 3px solid var(--claws-master-bg-primary); border-radius: 50%; animation: spin 1s linear infinite; margin: 0 auto 1rem;"></div>
        <p style="margin: 0; color: #6b7280;">Processing...</p>
    </div>
</div>

<style>
/* CLAWS Master Header CSS Custom Properties - Single Source of Truth */
:root {
    /* Master Header Properties (inherited by all child headers) */
    --claws-master-bg-primary: <?php echo esc_attr(get_option('claws_primary_color', '#C1292E')); ?>;
    --claws-master-bg-secondary: <?php echo esc_attr(get_option('claws_secondary_color', '#00274D')); ?>;
    --claws-master-text-color: <?php echo esc_attr(get_option('claws_header_text_color', 'white')); ?>;
    --claws-master-accent-color: <?php echo esc_attr(get_option('claws_primary_color', '#C1292E')); ?>;
    --claws-master-bg: <?php 
        $color_scheme_type = get_option('claws_color_scheme_type', 'gradient');
        $primary_color = get_option('claws_primary_color', '#C1292E');
        $secondary_color = get_option('claws_secondary_color', '#00274D');
        
        if ($color_scheme_type === 'solid') {
            echo esc_attr($primary_color);
        } else {
            echo 'linear-gradient(to right, ' . esc_attr($primary_color) . ', ' . esc_attr($secondary_color) . ')';
        }
    ?>;
}

/* Master Header Class - Single Source of Truth */
.claws-master-header,
.claws-child-header {
    background: var(--claws-master-bg) !important;
    color: var(--claws-master-text-color) !important;
}

/* Child Elements Inheriting Master Colors */
.claws-child-button {
    background: var(--claws-master-bg-primary) !important;
    color: var(--claws-master-text-color) !important;
}

.claws-child-accent {
    accent-color: var(--claws-master-accent-color) !important;
}

/* Tab States */
.claws-tab-active {
    background: var(--claws-master-bg-primary) !important;
    color: var(--claws-master-text-color) !important;
}

.claws-volunteers-subtab-active {
    background: var(--claws-master-bg-primary) !important;
    color: var(--claws-master-text-color) !important;
}

/* CLAWS App Styles */
.claws-app-wrapper { 
    font-family: system-ui, -apple-system, sans-serif; 
}

/* Responsive container - mobile first approach */
.claws-responsive-container {
    width: 100%;
    max-width: 480px; /* Mobile/tablet default */
}

/* Tablet landscape and small desktop */
@media (min-width: 768px) {
    .claws-responsive-container {
        max-width: 720px;
    }
}

/* Desktop */
@media (min-width: 1024px) {
    .claws-responsive-container {
        max-width: 900px;
    }
}

/* Large desktop */
@media (min-width: 1280px) {
    .claws-responsive-container {
        max-width: 1100px;
    }
}

/* Extra large desktop */
@media (min-width: 1536px) {
    .claws-responsive-container {
        max-width: 1300px;
    }
}

/* Optimize internal layout for larger screens */
@media (min-width: 1024px) {
    /* Make better use of horizontal space for forms and content */
    .claws-modal {
        max-width: 950px !important;
    }
    
    /* Improve spacing for wider screens */
    .claws-content-section {
        padding: 1.5rem;
    }
    
    /* Better grid layouts for wider screens */
    .claws-form-section {
        margin-bottom: 1.5rem;
    }
}

@media (min-width: 1280px) {
    /* Even more space utilization for very wide screens */
    .claws-modal {
        max-width: 1100px !important;
    }
    
    .claws-content-section {
        padding: 2rem;
    }
}

/* Legacy header class - now uses CSS custom properties */
.claws-header-gradient {
    background: var(--claws-master-bg) !important;
    color: var(--claws-master-text-color) !important;
}

.claws-section-hidden {
    display: none !important;
}

.claws-login-required {
    background: #dc2626;
    color: white;
    padding: 0.5rem;
    text-align: center;
    font-weight: bold;
    margin-bottom: 1rem;
}

.claws-content-section {
    min-height: 400px;
}

/* Logo container */
.claws-logo-container {
    position: relative;
}

.claws-logo-container img {
    transition: opacity 0.2s ease-in-out;
}

/* Loading animation */
@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

.claws-volunteers-subtab-section {
    transition: all 0.3s ease-in-out;
}

/* Modal and form styles will be added by the main CSS file */
</style>

<!-- Completed Task Modal -->
<div id="claws-completed-task-modal" class="claws-modal-backdrop" style="display: none;">
    <div class="claws-modal">
        <div class="claws-modal-header">
            <h3>✅ Enter Completed Task</h3>
            <button onclick="CLAWSApp.hideCompletedTaskForm()" class="claws-modal-close" style="background: none; border: none; font-size: 1.5rem; cursor: pointer; color: #6b7280; padding: 0.25rem; border-radius: 0.25rem;">×</button>
        </div>
        
        <div class="claws-modal-content" style="padding: 1rem; max-height: 70vh; overflow-y: auto;">
            
            <!-- All Fields Required Note -->
            <div style="background: #fef3c7; border: 1px solid #f59e0b; border-radius: 0.5rem; padding: 0.75rem; margin-bottom: 1rem; text-align: center;">
                <p style="margin: 0; font-size: 0.875rem; color: #92400e; font-weight: 500;">
                    All fields required
                </p>
            </div>

            <!-- Task Date -->
            <div class="claws-form-section">
                <label class="claws-form-label">Date Task Was Completed</label>
                <input type="date" id="claws-task-date" class="claws-form-input" style="width: 100%; box-sizing: border-box;" />
            </div>

            <!-- Task Type -->
            <div class="claws-form-section">
                <label class="claws-form-label">Type of Task/Event</label>
                <select id="claws-task-type" class="claws-form-select" style="width: 100%; box-sizing: border-box;">
                    <!-- Will be populated by JavaScript with unified types -->
                </select>
            </div>

            <!-- Colony Selection (for Colony Care tasks) -->
            <div id="claws-task-colony-section" class="claws-form-section" style="display: none;">
                <label class="claws-form-label">Select Colony</label>
                <select id="claws-task-colony" class="claws-form-select" style="width: 100%; box-sizing: border-box;">
                    <option value="">Choose a colony...</option>
                    <!-- Colonies will be populated dynamically -->
                </select>
            </div>

            <!-- Task Description -->
            <div class="claws-form-section">
                <label class="claws-form-label">Task Description</label>
                <textarea id="claws-task-description" class="claws-form-textarea" placeholder="Describe the work you completed..." style="width: 100%; box-sizing: border-box; min-height: 4rem;"></textarea>
            </div>

            <!-- Event/Project Linkage Section -->
            <div class="claws-form-section" style="background: #f0f9ff; padding: 1rem; border-radius: 0.5rem; border: 1px solid #bfdbfe;">
                <label class="claws-form-label" style="color: #1e40af; margin-bottom: 0.75rem;">🔗 Link Task to Event or Project (Optional)</label>
                
                <!-- Tied to Event -->
                <div style="margin-bottom: 0.75rem;">
                    <label style="display: flex; align-items: center; gap: 0.5rem; cursor: pointer;">
                        <input type="checkbox" id="claws-task-tied-to-event" onchange="CLAWSApp.toggleEventProjectDropdowns()" style="accent-color: var(--claws-master-bg-primary);" />
                        <span style="font-size: 0.875rem; font-weight: 500; color: #374151;">Tied to a Specific Event</span>
                    </label>
                    <div id="claws-task-event-dropdown-section" style="display: none; margin-top: 0.5rem; margin-left: 1.5rem;">
                        <select id="claws-task-event-id" class="claws-form-select" style="width: 100%; box-sizing: border-box;">
                            <option value="">Select event...</option>
                            <!-- Will be populated with user's events -->
                        </select>
                    </div>
                </div>
                
                <!-- Tied to Project -->
                <div>
                    <label style="display: flex; align-items: center; gap: 0.5rem; cursor: pointer;">
                        <input type="checkbox" id="claws-task-tied-to-project" onchange="CLAWSApp.toggleEventProjectDropdowns()" style="accent-color: var(--claws-master-bg-primary);" />
                        <span style="font-size: 0.875rem; font-weight: 500; color: #374151;">Tied to an Ongoing Project</span>
                    </label>
                    <div id="claws-task-project-dropdown-section" style="display: none; margin-top: 0.5rem; margin-left: 1.5rem;">
                        <select id="claws-task-project-id" class="claws-form-select" style="width: 100%; box-sizing: border-box;">
                            <option value="">Select project...</option>
                            <!-- Will be populated with user's projects -->
                        </select>
                    </div>
                </div>
                
                <!-- Help Text -->
                <p class="description" style="margin-top: 0.75rem; font-size: 0.75rem; color: #6b7280; font-style: italic;">
                    💡 If a checkbox is grayed out, it means you're not currently part of any events or projects as either a lead or volunteer.
                </p>
            </div>

            <!-- Time Tracking -->
            <div class="claws-form-section">
                <label class="claws-form-label">Time Spent on Task</label>
                <div style="display: grid; grid-template-columns: 1fr 1fr 1fr; gap: 0.75rem; margin-bottom: 0.5rem;">
                    <div>
                        <label style="font-size: 0.75rem; color: #6b7280; margin-bottom: 0.25rem; display: block;">Start Time</label>
                        <input type="time" id="claws-task-start-time" class="claws-form-input" style="width: 100%; box-sizing: border-box;" />
                    </div>
                    <div>
                        <label style="font-size: 0.75rem; color: #6b7280; margin-bottom: 0.25rem; display: block;">End Time</label>
                        <input type="time" id="claws-task-end-time" class="claws-form-input" style="width: 100%; box-sizing: border-box;" />
                    </div>
                    <div>
                        <label style="font-size: 0.75rem; color: #6b7280; margin-bottom: 0.25rem; display: block;">Total Hours</label>
                        <input type="text" id="claws-task-total-hours" class="claws-form-input" readonly style="width: 100%; box-sizing: border-box; background: #f9fafb;" placeholder="Auto-calculated" />
                    </div>
                </div>
            </div>

            <!-- Coordinator for Review -->
            <div class="claws-form-section">
                <label class="claws-form-label">Coordinator to Review/Approve</label>
                <select id="claws-task-coordinator" class="claws-form-select" style="width: 100%; box-sizing: border-box;">
                    <option value="">Select coordinator...</option>
                    <!-- Coordinators will be populated dynamically -->
                </select>
                <p class="description" style="margin-top: 0.5rem; font-size: 0.75rem; color: #6b7280;">
                    This person will receive a notification to review and approve your completed task.
                </p>
            </div>

            <!-- Coordinator Approval Section - HIDDEN IN MODAL, ONLY VISIBLE IN ADMIN TAB -->
            <!-- This section is now only visible when viewing tasks in the Admin > Pending Approvals tab -->
            <?php /* Coordinator approval moved to Admin tab only */ ?>

            <!-- Save Button -->
            <div style="text-align: center; margin-top: 2rem;">
                <button onclick="CLAWSApp.saveCompletedTask()" style="background: linear-gradient(135deg, #3b82f6, #1d4ed8); color: white; border: none; border-radius: 0.75rem; padding: 1rem 2rem; font-weight: 600; cursor: pointer; font-size: 1rem;">
                    💾 Save Completed Task
                </button>
            </div>
        </div>
    </div>
</div>

<script>
// CLAWS app container loaded
document.addEventListener('DOMContentLoaded', function() {
    console.log('CLAWS App container loaded');
    
    // App initialization is handled by claws-core.js - no need to initialize here
    console.log('App initialization delegated to claws-core.js');
});
</script>